/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.resolver;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import pro.gravit.repackage.io.netty.resolver.HostsFileEntriesProvider;
import pro.gravit.repackage.io.netty.resolver.HostsFileEntriesResolver;
import pro.gravit.repackage.io.netty.resolver.ResolvedAddressTypes;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public final class DefaultHostsFileEntriesResolver
implements HostsFileEntriesResolver {
    private final Map<String, List<InetAddress>> inet4Entries;
    private final Map<String, List<InetAddress>> inet6Entries;

    public DefaultHostsFileEntriesResolver() {
        this(DefaultHostsFileEntriesResolver.parseEntries());
    }

    DefaultHostsFileEntriesResolver(HostsFileEntriesProvider hostsFileEntriesProvider) {
        this.inet4Entries = hostsFileEntriesProvider.ipv4Entries();
        this.inet6Entries = hostsFileEntriesProvider.ipv6Entries();
    }

    @Override
    public InetAddress address(String string, ResolvedAddressTypes resolvedAddressTypes) {
        String string2 = this.normalize(string);
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return DefaultHostsFileEntriesResolver.firstAddress(this.inet4Entries.get(string2));
            }
            case IPV6_ONLY: {
                return DefaultHostsFileEntriesResolver.firstAddress(this.inet6Entries.get(string2));
            }
            case IPV4_PREFERRED: {
                InetAddress inetAddress = DefaultHostsFileEntriesResolver.firstAddress(this.inet4Entries.get(string2));
                return inetAddress != null ? inetAddress : DefaultHostsFileEntriesResolver.firstAddress(this.inet6Entries.get(string2));
            }
            case IPV6_PREFERRED: {
                InetAddress inetAddress = DefaultHostsFileEntriesResolver.firstAddress(this.inet6Entries.get(string2));
                return inetAddress != null ? inetAddress : DefaultHostsFileEntriesResolver.firstAddress(this.inet4Entries.get(string2));
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    public List<InetAddress> addresses(String string, ResolvedAddressTypes resolvedAddressTypes) {
        String string2 = this.normalize(string);
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return this.inet4Entries.get(string2);
            }
            case IPV6_ONLY: {
                return this.inet6Entries.get(string2);
            }
            case IPV4_PREFERRED: {
                List<InetAddress> list = this.inet4Entries.get(string2);
                return list != null ? DefaultHostsFileEntriesResolver.allAddresses(list, this.inet6Entries.get(string2)) : this.inet6Entries.get(string2);
            }
            case IPV6_PREFERRED: {
                List<InetAddress> list = this.inet6Entries.get(string2);
                return list != null ? DefaultHostsFileEntriesResolver.allAddresses(list, this.inet4Entries.get(string2)) : this.inet4Entries.get(string2);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    String normalize(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    private static List<InetAddress> allAddresses(List<InetAddress> list, List<InetAddress> list2) {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(list.size() + (list2 == null ? 0 : list2.size()));
        arrayList.addAll(list);
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private static InetAddress firstAddress(List<InetAddress> list) {
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    private static HostsFileEntriesProvider parseEntries() {
        if (PlatformDependent.isWindows()) {
            return HostsFileEntriesProvider.parser().parseSilently(Charset.defaultCharset(), CharsetUtil.UTF_16, CharsetUtil.UTF_8);
        }
        return HostsFileEntriesProvider.parser().parseSilently();
    }
}

