/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.PrivilegedAction;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

final class NetUtil$1
implements PrivilegedAction<Integer> {
    NetUtil$1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer run() {
        int n = PlatformDependent.isWindows() ? 200 : 128;
        File file = new File("/proc/sys/net/core/somaxconn");
        BufferedReader bufferedReader = null;
        try {
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                n = Integer.parseInt(bufferedReader.readLine());
                if (NetUtil.access$000().isDebugEnabled()) {
                    NetUtil.access$000().debug("{}: {}", (Object)file, (Object)n);
                }
            } else {
                Integer n2 = null;
                if (SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.net.somaxconn.trySysctl", false)) {
                    n2 = NetUtil.access$100("kern.ipc.somaxconn");
                    if (n2 == null) {
                        n2 = NetUtil.access$100("kern.ipc.soacceptqueue");
                        if (n2 != null) {
                            n = n2;
                        }
                    } else {
                        n = n2;
                    }
                }
                if (n2 == null) {
                    NetUtil.access$000().debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)n);
                }
            }
        }
        catch (Exception exception) {
            if (NetUtil.access$000().isDebugEnabled()) {
                NetUtil.access$000().debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", file, n, exception);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }
}

