/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import pro.gravit.repackage.io.netty.util.NetUtilInitializations$NetworkIfaceAndInetAddress;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SocketUtils;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

final class NetUtilInitializations {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NetUtilInitializations.class);

    private NetUtilInitializations() {
    }

    static Inet4Address createLocalhost4() {
        byte[] byArray = new byte[]{127, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress("localhost", byArray);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        return inet4Address;
    }

    static Inet6Address createLocalhost6() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet6Address inet6Address = null;
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress("localhost", byArray);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        return inet6Address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NetUtilInitializations$NetworkIfaceAndInetAddress determineLoopback(Inet4Address inet4Address, Inet6Address inet6Address) {
        Enumeration<InetAddress> enumeration;
        Object object;
        Object object2;
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        try {
            object2 = NetworkInterface.getNetworkInterfaces();
            if (object2 != null) {
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (!SocketUtils.addressesFromNetworkInterface((NetworkInterface)object).hasMoreElements()) continue;
                    arrayList.add((NetworkInterface)object);
                }
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        object2 = null;
        object = null;
        block10: for (NetworkInterface networkInterface : arrayList) {
            enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface);
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object2 = networkInterface;
                object = inetAddress;
                break block10;
            }
        }
        if (object2 == null) {
            try {
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.isLoopback() || !(enumeration = SocketUtils.addressesFromNetworkInterface(networkInterface)).hasMoreElements()) continue;
                    object2 = networkInterface;
                    object = enumeration.nextElement();
                    break;
                }
                if (object2 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object2 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object2).getName(), ((NetworkInterface)object2).getDisplayName(), ((InetAddress)object).getHostAddress());
        } else if (object == null) {
            try {
                if (NetworkInterface.getByInetAddress(inet6Address) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)inet6Address);
                    object = inet6Address;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
        }
        return new NetUtilInitializations$NetworkIfaceAndInetAddress((NetworkInterface)object2, (InetAddress)object);
    }
}

