/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.util.Recycler;
import pro.gravit.repackage.io.netty.util.Recycler$DefaultHandle;
import pro.gravit.repackage.io.netty.util.Recycler$WeakOrderQueue;

final class Recycler$Stack<T> {
    final Recycler<T> parent;
    final WeakReference<Thread> threadRef;
    final AtomicInteger availableSharedCapacity;
    private final int maxDelayedQueues;
    private final int maxCapacity;
    private final int interval;
    private final int delayedQueueInterval;
    Recycler$DefaultHandle<?>[] elements;
    int size;
    private int handleRecycleCount;
    private Recycler$WeakOrderQueue cursor;
    private Recycler$WeakOrderQueue prev;
    private volatile Recycler$WeakOrderQueue head;

    Recycler$Stack(Recycler<T> recycler, Thread thread, int n, int n2, int n3, int n4, int n5) {
        this.parent = recycler;
        this.threadRef = new WeakReference<Thread>(thread);
        this.maxCapacity = n;
        this.availableSharedCapacity = new AtomicInteger(Math.max(n / n2, Recycler.access$600()));
        this.elements = new Recycler$DefaultHandle[Math.min(Recycler.access$900(), n)];
        this.interval = n3;
        this.delayedQueueInterval = n5;
        this.handleRecycleCount = n3;
        this.maxDelayedQueues = n4;
    }

    synchronized void setHead(Recycler$WeakOrderQueue recycler$WeakOrderQueue) {
        recycler$WeakOrderQueue.setNext(this.head);
        this.head = recycler$WeakOrderQueue;
    }

    int increaseCapacity(int n) {
        int n2 = this.elements.length;
        int n3 = this.maxCapacity;
        while ((n2 <<= 1) < n && n2 < n3) {
        }
        if ((n2 = Math.min(n2, n3)) != this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, n2);
        }
        return n2;
    }

    Recycler$DefaultHandle<T> pop() {
        int n = this.size;
        if (n == 0) {
            if (!this.scavenge()) {
                return null;
            }
            n = this.size;
            if (n <= 0) {
                return null;
            }
        }
        Recycler$DefaultHandle<?> recycler$DefaultHandle = this.elements[--n];
        this.elements[n] = null;
        this.size = n;
        if (recycler$DefaultHandle.lastRecycledId != recycler$DefaultHandle.recycleId) {
            throw new IllegalStateException("recycled multiple times");
        }
        recycler$DefaultHandle.recycleId = 0;
        recycler$DefaultHandle.lastRecycledId = 0;
        return recycler$DefaultHandle;
    }

    private boolean scavenge() {
        if (this.scavengeSome()) {
            return true;
        }
        this.prev = null;
        this.cursor = this.head;
        return false;
    }

    private boolean scavengeSome() {
        Recycler$WeakOrderQueue recycler$WeakOrderQueue;
        Recycler$WeakOrderQueue recycler$WeakOrderQueue2;
        Recycler$WeakOrderQueue recycler$WeakOrderQueue3 = this.cursor;
        if (recycler$WeakOrderQueue3 == null) {
            recycler$WeakOrderQueue2 = null;
            recycler$WeakOrderQueue3 = this.head;
            if (recycler$WeakOrderQueue3 == null) {
                return false;
            }
        } else {
            recycler$WeakOrderQueue2 = this.prev;
        }
        boolean bl = false;
        do {
            if (recycler$WeakOrderQueue3.transfer(this)) {
                bl = true;
                break;
            }
            recycler$WeakOrderQueue = recycler$WeakOrderQueue3.getNext();
            if (recycler$WeakOrderQueue3.get() == null) {
                if (recycler$WeakOrderQueue3.hasFinalData()) {
                    while (recycler$WeakOrderQueue3.transfer(this)) {
                        bl = true;
                    }
                }
                if (recycler$WeakOrderQueue2 == null) continue;
                recycler$WeakOrderQueue3.reclaimAllSpaceAndUnlink();
                recycler$WeakOrderQueue2.setNext(recycler$WeakOrderQueue);
                continue;
            }
            recycler$WeakOrderQueue2 = recycler$WeakOrderQueue3;
        } while ((recycler$WeakOrderQueue3 = recycler$WeakOrderQueue) != null && !bl);
        this.prev = recycler$WeakOrderQueue2;
        this.cursor = recycler$WeakOrderQueue3;
        return bl;
    }

    void push(Recycler$DefaultHandle<?> recycler$DefaultHandle) {
        Thread thread = Thread.currentThread();
        if (this.threadRef.get() == thread) {
            this.pushNow(recycler$DefaultHandle);
        } else {
            this.pushLater(recycler$DefaultHandle, thread);
        }
    }

    private void pushNow(Recycler$DefaultHandle<?> recycler$DefaultHandle) {
        if (recycler$DefaultHandle.recycleId != 0 || !recycler$DefaultHandle.compareAndSetLastRecycledId(0, Recycler.access$1000())) {
            throw new IllegalStateException("recycled already");
        }
        recycler$DefaultHandle.recycleId = Recycler.access$1000();
        int n = this.size;
        if (n >= this.maxCapacity || this.dropHandle(recycler$DefaultHandle)) {
            return;
        }
        if (n == this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, Math.min(n << 1, this.maxCapacity));
        }
        this.elements[n] = recycler$DefaultHandle;
        this.size = n + 1;
    }

    private void pushLater(Recycler$DefaultHandle<?> recycler$DefaultHandle, Thread thread) {
        if (this.maxDelayedQueues == 0) {
            return;
        }
        Map map = (Map)Recycler.access$500().get();
        Recycler$WeakOrderQueue recycler$WeakOrderQueue = (Recycler$WeakOrderQueue)map.get(this);
        if (recycler$WeakOrderQueue == null) {
            if (map.size() >= this.maxDelayedQueues) {
                map.put(this, Recycler$WeakOrderQueue.DUMMY);
                return;
            }
            recycler$WeakOrderQueue = this.newWeakOrderQueue(thread);
            if (recycler$WeakOrderQueue == null) {
                return;
            }
            map.put(this, recycler$WeakOrderQueue);
        } else if (recycler$WeakOrderQueue == Recycler$WeakOrderQueue.DUMMY) {
            return;
        }
        recycler$WeakOrderQueue.add(recycler$DefaultHandle);
    }

    private Recycler$WeakOrderQueue newWeakOrderQueue(Thread thread) {
        return Recycler$WeakOrderQueue.newQueue(this, thread);
    }

    boolean dropHandle(Recycler$DefaultHandle<?> recycler$DefaultHandle) {
        if (!recycler$DefaultHandle.hasBeenRecycled) {
            if (this.handleRecycleCount < this.interval) {
                ++this.handleRecycleCount;
                return true;
            }
            this.handleRecycleCount = 0;
            recycler$DefaultHandle.hasBeenRecycled = true;
        }
        return false;
    }

    Recycler$DefaultHandle<T> newHandle() {
        return new Recycler$DefaultHandle(this);
    }

    static /* synthetic */ int access$800(Recycler$Stack recycler$Stack) {
        return recycler$Stack.delayedQueueInterval;
    }
}

