/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.util.NettyRuntime;
import pro.gravit.repackage.io.netty.util.Recycler;
import pro.gravit.repackage.io.netty.util.Recycler$1;
import pro.gravit.repackage.io.netty.util.Recycler$2;
import pro.gravit.repackage.io.netty.util.Recycler$3;
import pro.gravit.repackage.io.netty.util.Recycler$DefaultHandle;
import pro.gravit.repackage.io.netty.util.Recycler$Handle;
import pro.gravit.repackage.io.netty.util.Recycler$Stack;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final Recycler$Handle NOOP_HANDLE = new Recycler$1();
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(Integer.MIN_VALUE);
    private static final int OWN_THREAD_ID = ID_GENERATOR.getAndIncrement();
    private static final int DEFAULT_INITIAL_MAX_CAPACITY_PER_THREAD = 4096;
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int INITIAL_CAPACITY;
    private static final int MAX_SHARED_CAPACITY_FACTOR;
    private static final int MAX_DELAYED_QUEUES_PER_THREAD;
    private static final int LINK_CAPACITY;
    private static final int RATIO;
    private static final int DELAYED_QUEUE_RATIO;
    private final int maxCapacityPerThread;
    private final int maxSharedCapacityFactor;
    private final int interval;
    private final int maxDelayedQueuesPerThread;
    private final int delayedQueueInterval;
    private final FastThreadLocal<Recycler$Stack<T>> threadLocal = new Recycler$2(this);
    private static final FastThreadLocal<Map<Recycler$Stack<?>, WeakOrderQueue>> DELAYED_RECYCLED;

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    protected Recycler(int n) {
        this(n, MAX_SHARED_CAPACITY_FACTOR);
    }

    protected Recycler(int n, int n2) {
        this(n, n2, RATIO, MAX_DELAYED_QUEUES_PER_THREAD);
    }

    protected Recycler(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DELAYED_QUEUE_RATIO);
    }

    protected Recycler(int n, int n2, int n3, int n4, int n5) {
        this.interval = Math.max(0, n3);
        this.delayedQueueInterval = Math.max(0, n5);
        if (n <= 0) {
            this.maxCapacityPerThread = 0;
            this.maxSharedCapacityFactor = 1;
            this.maxDelayedQueuesPerThread = 0;
        } else {
            this.maxCapacityPerThread = n;
            this.maxSharedCapacityFactor = Math.max(1, n2);
            this.maxDelayedQueuesPerThread = Math.max(0, n4);
        }
    }

    public final T get() {
        if (this.maxCapacityPerThread == 0) {
            return this.newObject(NOOP_HANDLE);
        }
        Recycler$Stack<T> recycler$Stack = this.threadLocal.get();
        Recycler$DefaultHandle<T> recycler$DefaultHandle = recycler$Stack.pop();
        if (recycler$DefaultHandle == null) {
            recycler$DefaultHandle = recycler$Stack.newHandle();
            recycler$DefaultHandle.value = this.newObject(recycler$DefaultHandle);
        }
        return (T)recycler$DefaultHandle.value;
    }

    @Deprecated
    public final boolean recycle(T t, Recycler$Handle<T> recycler$Handle) {
        if (recycler$Handle == NOOP_HANDLE) {
            return false;
        }
        Recycler$DefaultHandle recycler$DefaultHandle = (Recycler$DefaultHandle)recycler$Handle;
        if (recycler$DefaultHandle.stack.parent != this) {
            return false;
        }
        recycler$DefaultHandle.recycle((Object)t);
        return true;
    }

    final int threadLocalCapacity() {
        return this.threadLocal.get().elements.length;
    }

    final int threadLocalSize() {
        return this.threadLocal.get().size;
    }

    protected abstract T newObject(Recycler$Handle<T> var1);

    static /* synthetic */ int access$000(Recycler recycler) {
        return recycler.maxCapacityPerThread;
    }

    static /* synthetic */ int access$100(Recycler recycler) {
        return recycler.maxSharedCapacityFactor;
    }

    static /* synthetic */ int access$200(Recycler recycler) {
        return recycler.interval;
    }

    static /* synthetic */ int access$300(Recycler recycler) {
        return recycler.maxDelayedQueuesPerThread;
    }

    static /* synthetic */ int access$400(Recycler recycler) {
        return recycler.delayedQueueInterval;
    }

    static /* synthetic */ FastThreadLocal access$500() {
        return DELAYED_RECYCLED;
    }

    static /* synthetic */ int access$600() {
        return LINK_CAPACITY;
    }

    static /* synthetic */ AtomicInteger access$700() {
        return ID_GENERATOR;
    }

    static /* synthetic */ int access$900() {
        return INITIAL_CAPACITY;
    }

    static /* synthetic */ int access$1000() {
        return OWN_THREAD_ID;
    }

    static {
        int n = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.maxCapacity", 4096));
        if (n < 0) {
            n = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = n;
        MAX_SHARED_CAPACITY_FACTOR = Math.max(2, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.maxSharedCapacityFactor", 2));
        MAX_DELAYED_QUEUES_PER_THREAD = Math.max(0, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.maxDelayedQueuesPerThread", NettyRuntime.availableProcessors() * 2));
        LINK_CAPACITY = MathUtil.safeFindNextPositivePowerOfTwo(Math.max(SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.linkCapacity", 16), 16));
        RATIO = Math.max(0, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.ratio", 8));
        DELAYED_QUEUE_RATIO = Math.max(0, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.delayedQueue.ratio", RATIO));
        INITIAL_CAPACITY = Math.min(DEFAULT_MAX_CAPACITY_PER_THREAD, 256);
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: disabled");
                logger.debug("-Dio.netty.recycler.linkCapacity: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
                logger.debug("-Dio.netty.recycler.delayedQueue.ratio: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: {}", (Object)MAX_SHARED_CAPACITY_FACTOR);
                logger.debug("-Dio.netty.recycler.linkCapacity: {}", (Object)LINK_CAPACITY);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
                logger.debug("-Dio.netty.recycler.delayedQueue.ratio: {}", (Object)DELAYED_QUEUE_RATIO);
            }
        }
        DELAYED_RECYCLED = new Recycler$3();
    }
}

