/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

import java.util.Collection;
import java.util.Map;

public final class ObjectUtil {
    private static final float FLOAT_ZERO = 0.0f;
    private static final double DOUBLE_ZERO = 0.0;
    private static final long LONG_ZERO = 0L;
    private static final int INT_ZERO = 0;

    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T t, String string) {
        if (t == null) {
            throw new NullPointerException(string);
        }
        return t;
    }

    public static <T> T[] deepCheckNotNull(String string, T ... TArray) {
        if (TArray == null) {
            throw new NullPointerException(string);
        }
        for (T t : TArray) {
            if (t != null) continue;
            throw new NullPointerException(string);
        }
        return TArray;
    }

    public static <T> T checkNotNullWithIAE(T t, String string) {
        if (t == null) {
            throw new IllegalArgumentException("Param '" + string + "' must not be null");
        }
        return t;
    }

    public static <T> T checkNotNullArrayParam(T t, int n, String string) {
        if (t == null) {
            throw new IllegalArgumentException("Array index " + n + " of parameter '" + string + "' must not be null");
        }
        return t;
    }

    public static int checkPositive(int n, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException(string + " : " + n + " (expected: > 0)");
        }
        return n;
    }

    public static long checkPositive(long l, String string) {
        if (l <= 0L) {
            throw new IllegalArgumentException(string + " : " + l + " (expected: > 0)");
        }
        return l;
    }

    public static double checkPositive(double d, String string) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(string + " : " + d + " (expected: > 0)");
        }
        return d;
    }

    public static float checkPositive(float f, String string) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(string + " : " + f + " (expected: > 0)");
        }
        return f;
    }

    public static int checkPositiveOrZero(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException(string + " : " + n + " (expected: >= 0)");
        }
        return n;
    }

    public static long checkPositiveOrZero(long l, String string) {
        if (l < 0L) {
            throw new IllegalArgumentException(string + " : " + l + " (expected: >= 0)");
        }
        return l;
    }

    public static double checkPositiveOrZero(double d, String string) {
        if (d < 0.0) {
            throw new IllegalArgumentException(string + " : " + d + " (expected: >= 0)");
        }
        return d;
    }

    public static float checkPositiveOrZero(float f, String string) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(string + " : " + f + " (expected: >= 0)");
        }
        return f;
    }

    public static int checkInRange(int n, int n2, int n3, String string) {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException(string + ": " + n + " (expected: " + n2 + "-" + n3 + ")");
        }
        return n;
    }

    public static long checkInRange(long l, long l2, long l3, String string) {
        if (l < l2 || l > l3) {
            throw new IllegalArgumentException(string + ": " + l + " (expected: " + l2 + "-" + l3 + ")");
        }
        return l;
    }

    public static <T> T[] checkNonEmpty(T[] TArray, String string) {
        if (ObjectUtil.checkNotNull(TArray, string).length == 0) {
            throw new IllegalArgumentException("Param '" + string + "' must not be empty");
        }
        return TArray;
    }

    public static byte[] checkNonEmpty(byte[] byArray, String string) {
        if (ObjectUtil.checkNotNull(byArray, string).length == 0) {
            throw new IllegalArgumentException("Param '" + string + "' must not be empty");
        }
        return byArray;
    }

    public static char[] checkNonEmpty(char[] cArray, String string) {
        if (ObjectUtil.checkNotNull(cArray, string).length == 0) {
            throw new IllegalArgumentException("Param '" + string + "' must not be empty");
        }
        return cArray;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T t, String string) {
        if (ObjectUtil.checkNotNull(t, string).size() == 0) {
            throw new IllegalArgumentException("Param '" + string + "' must not be empty");
        }
        return t;
    }

    public static String checkNonEmpty(String string, String string2) {
        if (ObjectUtil.checkNotNull(string, string2).isEmpty()) {
            throw new IllegalArgumentException("Param '" + string2 + "' must not be empty");
        }
        return string;
    }

    public static <K, V, T extends Map<K, V>> T checkNonEmpty(T t, String string) {
        if (ObjectUtil.checkNotNull(t, string).isEmpty()) {
            throw new IllegalArgumentException("Param '" + string + "' must not be empty");
        }
        return t;
    }

    public static CharSequence checkNonEmpty(CharSequence charSequence, String string) {
        if (ObjectUtil.checkNotNull(charSequence, string).length() == 0) {
            throw new IllegalArgumentException("Param '" + string + "' must not be empty");
        }
        return charSequence;
    }

    public static String checkNonEmptyAfterTrim(String string, String string2) {
        String string3 = ObjectUtil.checkNotNull(string, string2).trim();
        return ObjectUtil.checkNonEmpty(string3, string2);
    }

    public static int intValue(Integer n, int n2) {
        return n != null ? n : n2;
    }

    public static long longValue(Long l, long l2) {
        return l != null ? l : l2;
    }
}

