/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import pro.gravit.repackage.io.netty.util.internal.ConstantTimeUtils;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$1;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$10;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$11;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$2;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$3;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$4;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$5;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$6;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$7;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$8;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent0$9;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;
import sun.misc.Unsafe;

@SuppressJava6Requirement(reason="Unsafe access is guarded")
final class PlatformDependent0 {
    private static final InternalLogger logger;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_INDEX_SCALE;
    private static final long LONG_ARRAY_BASE_OFFSET;
    private static final long LONG_ARRAY_INDEX_SCALE;
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR;
    private static final Throwable EXPLICIT_NO_UNSAFE_CAUSE;
    private static final Method ALLOCATE_ARRAY_METHOD;
    private static final Method ALIGN_SLICE;
    private static final int JAVA_VERSION;
    private static final boolean IS_ANDROID;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final Object INTERNAL_UNSAFE;
    private static final boolean IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    private static final boolean RUNNING_IN_NATIVE_IMAGE;
    static final Unsafe UNSAFE;
    static final int HASH_CODE_ASCII_SEED = -1028477387;
    static final int HASH_CODE_C1 = -862048943;
    static final int HASH_CODE_C2 = 461845907;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final boolean UNALIGNED;

    private static boolean unsafeStaticFieldOffsetSupported() {
        return !RUNNING_IN_NATIVE_IMAGE;
    }

    static boolean isExplicitNoUnsafe() {
        return EXPLICIT_NO_UNSAFE_CAUSE != null;
    }

    private static Throwable explicitNoUnsafeCause0() {
        boolean bl = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)bl);
        if (bl) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
        }
        String string = SystemPropertyUtil.contains("pro.gravit.repackage.io.netty.tryUnsafe") ? "pro.gravit.repackage.io.netty.tryUnsafe" : "org.jboss.netty.tryUnsafe";
        if (!SystemPropertyUtil.getBoolean(string, true)) {
            String string2 = "sun.misc.Unsafe: unavailable (" + string + ")";
            logger.debug(string2);
            return new UnsupportedOperationException(string2);
        }
        return null;
    }

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable throwable) {
        UNSAFE.throwException(ObjectUtil.checkNotNull(throwable, "cause"));
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), n), n);
    }

    static ByteBuffer allocateDirectNoCleaner(int n) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(Math.max(1, n)), n);
    }

    static boolean hasAlignSliceMethod() {
        return ALIGN_SLICE != null;
    }

    static ByteBuffer alignSlice(ByteBuffer byteBuffer, int n) {
        try {
            return (ByteBuffer)ALIGN_SLICE.invoke((Object)byteBuffer, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    static boolean hasAllocateArrayMethod() {
        return ALLOCATE_ARRAY_METHOD != null;
    }

    static byte[] allocateUninitializedArray(int n) {
        try {
            return (byte[])ALLOCATE_ARRAY_METHOD.invoke(INTERNAL_UNSAFE, Byte.TYPE, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    static ByteBuffer newDirectBuffer(long l, int n) {
        ObjectUtil.checkPositiveOrZero(n, "capacity");
        try {
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(l, n);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error(throwable);
        }
    }

    static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    static Object getObject(Object object, long l) {
        return UNSAFE.getObject(object, l);
    }

    static int getInt(Object object, long l) {
        return UNSAFE.getInt(object, l);
    }

    private static long getLong(Object object, long l) {
        return UNSAFE.getLong(object, l);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long l) {
        return UNSAFE.getByte(l);
    }

    static short getShort(long l) {
        return UNSAFE.getShort(l);
    }

    static int getInt(long l) {
        return UNSAFE.getInt(l);
    }

    static long getLong(long l) {
        return UNSAFE.getLong(l);
    }

    static byte getByte(byte[] byArray, int n) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static byte getByte(byte[] byArray, long l) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + l);
    }

    static short getShort(byte[] byArray, int n) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static int getInt(byte[] byArray, int n) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static int getInt(int[] nArray, long l) {
        return UNSAFE.getInt(nArray, INT_ARRAY_BASE_OFFSET + INT_ARRAY_INDEX_SCALE * l);
    }

    static int getIntVolatile(long l) {
        return UNSAFE.getIntVolatile(null, l);
    }

    static void putIntOrdered(long l, int n) {
        UNSAFE.putOrderedInt(null, l, n);
    }

    static long getLong(byte[] byArray, int n) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n);
    }

    static long getLong(long[] lArray, long l) {
        return UNSAFE.getLong(lArray, LONG_ARRAY_BASE_OFFSET + LONG_ARRAY_INDEX_SCALE * l);
    }

    static void putByte(long l, byte by) {
        UNSAFE.putByte(l, by);
    }

    static void putShort(long l, short s) {
        UNSAFE.putShort(l, s);
    }

    static void putInt(long l, int n) {
        UNSAFE.putInt(l, n);
    }

    static void putLong(long l, long l2) {
        UNSAFE.putLong(l, l2);
    }

    static void putByte(byte[] byArray, int n, byte by) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, by);
    }

    static void putByte(Object object, long l, byte by) {
        UNSAFE.putByte(object, l, by);
    }

    static void putShort(byte[] byArray, int n, short s) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, s);
    }

    static void putInt(byte[] byArray, int n, int n2) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, n2);
    }

    static void putLong(byte[] byArray, int n, long l) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, l);
    }

    static void putObject(Object object, long l, Object object2) {
        UNSAFE.putObject(object, l, object2);
    }

    static void copyMemory(long l, long l2, long l3) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(l, l2, l3);
        } else {
            UNSAFE.copyMemory(l, l2, l3);
        }
    }

    private static void copyMemoryWithSafePointPolling(long l, long l2, long l3) {
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x100000L);
            UNSAFE.copyMemory(l, l2, l4);
            l3 -= l4;
            l += l4;
            l2 += l4;
        }
    }

    static void copyMemory(Object object, long l, Object object2, long l2, long l3) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(object, l, object2, l2, l3);
        } else {
            UNSAFE.copyMemory(object, l, object2, l2, l3);
        }
    }

    private static void copyMemoryWithSafePointPolling(Object object, long l, Object object2, long l2, long l3) {
        while (l3 > 0L) {
            long l4 = Math.min(l3, 0x100000L);
            UNSAFE.copyMemory(object, l, object2, l2, l4);
            l3 -= l4;
            l += l4;
            l2 += l4;
        }
    }

    static void setMemory(long l, long l2, byte by) {
        UNSAFE.setMemory(l, l2, by);
    }

    static void setMemory(Object object, long l, long l2, byte by) {
        UNSAFE.setMemory(object, l, l2, by);
    }

    static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        long l;
        int n4 = n3 & 7;
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n;
        long l3 = n2 - n;
        if (n3 >= 8) {
            l = l2 + (long)n4;
            for (long i = l2 - 8L + (long)n3; i >= l; i -= 8L) {
                if (UNSAFE.getLong(byArray, i) == UNSAFE.getLong(byArray2, i + l3)) continue;
                return false;
            }
        }
        if (n4 >= 4 && UNSAFE.getInt(byArray, l = l2 + (long)(n4 -= 4)) != UNSAFE.getInt(byArray2, l + l3)) {
            return false;
        }
        l = l2 + l3;
        if (n4 >= 2) {
            return UNSAFE.getChar(byArray, l2) == UNSAFE.getChar(byArray2, l) && (n4 == 2 || UNSAFE.getByte(byArray, l2 + 2L) == UNSAFE.getByte(byArray2, l + 2L));
        }
        return n4 == 0 || UNSAFE.getByte(byArray, l2) == UNSAFE.getByte(byArray2, l);
    }

    static int equalsConstantTime(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        long l;
        long l2 = 0L;
        long l3 = n3 & 7;
        long l4 = BYTE_ARRAY_BASE_OFFSET + (long)n;
        long l5 = l4 + l3;
        long l6 = n2 - n;
        for (l = l4 - 8L + (long)n3; l >= l5; l -= 8L) {
            l2 |= UNSAFE.getLong(byArray, l) ^ UNSAFE.getLong(byArray2, l + l6);
        }
        if (l3 >= 4L) {
            l2 |= (long)(UNSAFE.getInt(byArray, l4) ^ UNSAFE.getInt(byArray2, l4 + l6));
            l3 -= 4L;
        }
        if (l3 >= 2L) {
            l = l5 - l3;
            l2 |= (long)(UNSAFE.getChar(byArray, l) ^ UNSAFE.getChar(byArray2, l + l6));
            l3 -= 2L;
        }
        if (l3 == 1L) {
            l = l5 - 1L;
            l2 |= (long)(UNSAFE.getByte(byArray, l) ^ UNSAFE.getByte(byArray2, l + l6));
        }
        return ConstantTimeUtils.equalsConstantTime(l2, 0L);
    }

    static boolean isZero(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return true;
        }
        long l = BYTE_ARRAY_BASE_OFFSET + (long)n;
        int n3 = n2 & 7;
        long l2 = l + (long)n3;
        for (long i = l - 8L + (long)n2; i >= l2; i -= 8L) {
            if (UNSAFE.getLong(byArray, i) == 0L) continue;
            return false;
        }
        if (n3 >= 4 && UNSAFE.getInt(byArray, l + (long)(n3 -= 4)) != 0) {
            return false;
        }
        if (n3 >= 2) {
            return UNSAFE.getChar(byArray, l) == '\u0000' && (n3 == 2 || byArray[n + 2] == 0);
        }
        return byArray[n] == 0;
    }

    static int hashCodeAscii(byte[] byArray, int n, int n2) {
        int n3 = -1028477387;
        long l = BYTE_ARRAY_BASE_OFFSET + (long)n;
        int n4 = n2 & 7;
        long l2 = l + (long)n4;
        for (long i = l - 8L + (long)n2; i >= l2; i -= 8L) {
            n3 = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(byArray, i), n3);
        }
        if (n4 == 0) {
            return n3;
        }
        int n5 = -862048943;
        if (n4 != 2 & n4 != 4 & n4 != 6) {
            n3 = n3 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l));
            n5 = 461845907;
            ++l;
        }
        if (n4 != 1 & n4 != 4 & n4 != 5) {
            n3 = n3 * n5 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l));
            n5 = n5 == -862048943 ? 461845907 : -862048943;
            l += 2L;
        }
        if (n4 >= 4) {
            return n3 * n5 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l));
        }
        return n3;
    }

    static int hashCodeAsciiCompute(long l, int n) {
        return n * -862048943 + PlatformDependent0.hashCodeAsciiSanitize((int)l) * 461845907 + (int)((l & 0x1F1F1F1F00000000L) >>> 32);
    }

    static int hashCodeAsciiSanitize(int n) {
        return n & 0x1F1F1F1F;
    }

    static int hashCodeAsciiSanitize(short s) {
        return s & 0x1F1F;
    }

    static int hashCodeAsciiSanitize(byte by) {
        return by & 0x1F;
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$9(clazz));
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$10());
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$11());
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static long allocateMemory(long l) {
        return UNSAFE.allocateMemory(l);
    }

    static void freeMemory(long l) {
        UNSAFE.freeMemory(l);
    }

    static long reallocateMemory(long l, long l2) {
        return UNSAFE.reallocateMemory(l, l2);
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    private static boolean isAndroid0() {
        String string = SystemPropertyUtil.get("java.vm.name");
        boolean bl = "Dalvik".equals(string);
        if (bl) {
            logger.debug("Platform: Android");
        }
        return bl;
    }

    private static boolean explicitTryReflectionSetAccessible0() {
        return SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.tryReflectionSetAccessible", PlatformDependent0.javaVersion() < 9);
    }

    static boolean isExplicitTryReflectionSetAccessible() {
        return IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    }

    static int javaVersion() {
        return JAVA_VERSION;
    }

    private static int javaVersion0() {
        int n = PlatformDependent0.isAndroid0() ? 6 : PlatformDependent0.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)n);
        return n;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        return PlatformDependent0.majorVersion(SystemPropertyUtil.get("java.specification.version", "1.6"));
    }

    static int majorVersion(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        if (nArray[0] == 1) {
            assert (nArray[1] >= 6);
            return nArray[1];
        }
        return nArray[0];
    }

    private PlatformDependent0() {
    }

    static /* synthetic */ boolean access$000() {
        return PlatformDependent0.unsafeStaticFieldOffsetSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        Unsafe unsafe;
        ByteBuffer byteBuffer;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        EXPLICIT_NO_UNSAFE_CAUSE = PlatformDependent0.explicitNoUnsafeCause0();
        JAVA_VERSION = PlatformDependent0.javaVersion0();
        IS_ANDROID = PlatformDependent0.isAndroid0();
        IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE = PlatformDependent0.explicitTryReflectionSetAccessible0();
        RUNNING_IN_NATIVE_IMAGE = SystemPropertyUtil.contains("org.graalvm.nativeimage.imagecode");
        Field field = null;
        Method method = null;
        Throwable throwable = null;
        Object object2 = null;
        throwable = EXPLICIT_NO_UNSAFE_CAUSE;
        if (throwable != null) {
            byteBuffer = null;
            field = null;
            unsafe = null;
            object2 = null;
        } else {
            long l;
            Object object3;
            Unsafe unsafe2;
            byteBuffer = ByteBuffer.allocateDirect(1);
            object = AccessController.doPrivileged(new PlatformDependent0$1());
            if (object instanceof Throwable) {
                unsafe = null;
                throwable = (Throwable)object;
                if (logger.isTraceEnabled()) {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Throwable)object);
                } else {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable: {}", (Object)((Throwable)object).getMessage());
                }
            } else {
                unsafe = (Unsafe)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object3 = AccessController.doPrivileged(new PlatformDependent0$2(unsafe2));
                if (object3 == null) {
                    logger.debug("sun.misc.Unsafe.copyMemory: available");
                } else {
                    unsafe = null;
                    throwable = (Throwable)object3;
                    if (logger.isTraceEnabled()) {
                        logger.debug("sun.misc.Unsafe.copyMemory: unavailable", (Throwable)object3);
                    } else {
                        logger.debug("sun.misc.Unsafe.copyMemory: unavailable: {}", (Object)((Throwable)object3).getMessage());
                    }
                }
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object3 = AccessController.doPrivileged(new PlatformDependent0$3(unsafe2, byteBuffer));
                if (object3 instanceof Field) {
                    field = (Field)object3;
                    logger.debug("java.nio.Buffer.address: available");
                } else {
                    throwable = (Throwable)object3;
                    if (logger.isTraceEnabled()) {
                        logger.debug("java.nio.Buffer.address: unavailable", (Throwable)object3);
                    } else {
                        logger.debug("java.nio.Buffer.address: unavailable: {}", (Object)((Throwable)object3).getMessage());
                    }
                    unsafe = null;
                }
            }
            if (unsafe != null && (l = (long)unsafe.arrayIndexScale(byte[].class)) != 1L) {
                logger.debug("unsafe.arrayIndexScale is {} (expected: 1). Not using unsafe.", (Object)l);
                throwable = new UnsupportedOperationException("Unexpected unsafe.arrayIndexScale");
                unsafe = null;
            }
        }
        UNSAFE_UNAVAILABILITY_CAUSE = throwable;
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_INDEX_SCALE = -1L;
            INT_ARRAY_BASE_OFFSET = -1L;
            INT_ARRAY_INDEX_SCALE = -1L;
            UNALIGNED = false;
            DIRECT_BUFFER_CONSTRUCTOR = null;
            ALLOCATE_ARRAY_METHOD = null;
        } else {
            Object object4;
            Object object5;
            boolean bl;
            long l = -1L;
            try {
                Object object6 = AccessController.doPrivileged(new PlatformDependent0$4(byteBuffer));
                if (object6 instanceof Constructor) {
                    l = UNSAFE.allocateMemory(1L);
                    try {
                        ((Constructor)object6).newInstance(l, 1);
                        object = (Constructor)object6;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (InstantiationException instantiationException) {
                        object = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object = null;
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.debug("direct buffer constructor: unavailable", (Throwable)object6);
                    } else {
                        logger.debug("direct buffer constructor: unavailable: {}", (Object)((Throwable)object6).getMessage());
                    }
                    object = null;
                }
            }
            finally {
                if (l != -1L) {
                    UNSAFE.freeMemory(l);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = object;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset(field);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            INT_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            INT_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
            LONG_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            LONG_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);
            Object object7 = AccessController.doPrivileged(new PlatformDependent0$5());
            if (object7 instanceof Boolean) {
                bl = (Boolean)object7;
                logger.debug("java.nio.Bits.unaligned: available, {}", (Object)bl);
            } else {
                object5 = SystemPropertyUtil.get("os.arch", "");
                bl = ((String)object5).matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
                object4 = (Throwable)object7;
                if (logger.isTraceEnabled()) {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}", (Object)bl, object4);
                } else {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}, {}", (Object)bl, (Object)((Throwable)object4).getMessage());
                }
            }
            UNALIGNED = bl;
            if (PlatformDependent0.javaVersion() >= 9) {
                object5 = AccessController.doPrivileged(new PlatformDependent0$6());
                if (!(object5 instanceof Throwable) && (object5 = AccessController.doPrivileged(new PlatformDependent0$7(object4 = (object2 = object5)))) instanceof Method) {
                    try {
                        Method method2 = (Method)object5;
                        byte[] byArray = (byte[])method2.invoke(object4, Byte.TYPE, 8);
                        assert (byArray.length == 8);
                        method = method2;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object5 = illegalAccessException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object5 = invocationTargetException;
                    }
                }
                if (object5 instanceof Throwable) {
                    if (logger.isTraceEnabled()) {
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable", (Throwable)object5);
                    } else {
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable: {}", (Object)((Throwable)object5).getMessage());
                    }
                } else {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): available");
                }
            } else {
                logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable prior to Java9");
            }
            ALLOCATE_ARRAY_METHOD = method;
        }
        ALIGN_SLICE = PlatformDependent0.javaVersion() > 9 ? (Method)AccessController.doPrivileged(new PlatformDependent0$8()) : null;
        INTERNAL_UNSAFE = object2;
        logger.debug("java.nio.DirectByteBuffer.<init>(long, int): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
    }
}

