/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public abstract class ReferenceCountUpdater<T extends ReferenceCounted> {
    protected ReferenceCountUpdater() {
    }

    public static long getUnsafeOffset(Class<? extends ReferenceCounted> clazz, String string) {
        try {
            if (PlatformDependent.hasUnsafe()) {
                return PlatformDependent.objectFieldOffset(clazz.getDeclaredField(string));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    protected abstract AtomicIntegerFieldUpdater<T> updater();

    protected abstract long unsafeOffset();

    public final int initialValue() {
        return 2;
    }

    private static int realRefCnt(int n) {
        return n != 2 && n != 4 && (n & 1) != 0 ? 0 : n >>> 1;
    }

    private static int toLiveRealRefCnt(int n, int n2) {
        if (n == 2 || n == 4 || (n & 1) == 0) {
            return n >>> 1;
        }
        throw new IllegalReferenceCountException(0, -n2);
    }

    private int nonVolatileRawCnt(T t) {
        long l = this.unsafeOffset();
        return l != -1L ? PlatformDependent.getInt(t, l) : this.updater().get(t);
    }

    public final int refCnt(T t) {
        return ReferenceCountUpdater.realRefCnt(this.updater().get(t));
    }

    public final boolean isLiveNonVolatile(T t) {
        long l = this.unsafeOffset();
        int n = l != -1L ? PlatformDependent.getInt(t, l) : this.updater().get(t);
        return n == 2 || n == 4 || n == 6 || n == 8 || (n & 1) == 0;
    }

    public final void setRefCnt(T t, int n) {
        this.updater().set(t, n > 0 ? n << 1 : 1);
    }

    public final void resetRefCnt(T t) {
        this.updater().set(t, this.initialValue());
    }

    public final T retain(T t) {
        return this.retain0(t, 1, 2);
    }

    public final T retain(T t, int n) {
        int n2 = ObjectUtil.checkPositive(n, "increment") << 1;
        return this.retain0(t, n, n2);
    }

    private T retain0(T t, int n, int n2) {
        int n3 = this.updater().getAndAdd(t, n2);
        if (n3 != 2 && n3 != 4 && (n3 & 1) != 0) {
            throw new IllegalReferenceCountException(0, n);
        }
        if (n3 <= 0 && n3 + n2 >= 0 || n3 >= 0 && n3 + n2 < n3) {
            this.updater().getAndAdd(t, -n2);
            throw new IllegalReferenceCountException(ReferenceCountUpdater.realRefCnt(n3), n);
        }
        return t;
    }

    public final boolean release(T t) {
        int n = this.nonVolatileRawCnt(t);
        return n == 2 ? this.tryFinalRelease0(t, 2) || this.retryRelease0(t, 1) : this.nonFinalRelease0(t, 1, n, ReferenceCountUpdater.toLiveRealRefCnt(n, 1));
    }

    public final boolean release(T t, int n) {
        int n2 = this.nonVolatileRawCnt(t);
        int n3 = ReferenceCountUpdater.toLiveRealRefCnt(n2, ObjectUtil.checkPositive(n, "decrement"));
        return n == n3 ? this.tryFinalRelease0(t, n2) || this.retryRelease0(t, n) : this.nonFinalRelease0(t, n, n2, n3);
    }

    private boolean tryFinalRelease0(T t, int n) {
        return this.updater().compareAndSet(t, n, 1);
    }

    private boolean nonFinalRelease0(T t, int n, int n2, int n3) {
        if (n < n3 && this.updater().compareAndSet(t, n2, n2 - (n << 1))) {
            return false;
        }
        return this.retryRelease0(t, n);
    }

    private boolean retryRelease0(T t, int n) {
        while (true) {
            int n2;
            int n3;
            if (n == (n3 = ReferenceCountUpdater.toLiveRealRefCnt(n2 = this.updater().get(t), n))) {
                if (this.tryFinalRelease0(t, n2)) {
                    return true;
                }
            } else if (n < n3) {
                if (this.updater().compareAndSet(t, n2, n2 - (n << 1))) {
                    return false;
                }
            } else {
                throw new IllegalReferenceCountException(n3, -n);
            }
            Thread.yield();
        }
    }
}

