/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueue$WeakIterator;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;

abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    public BaseMpscLinkedAtomicArrayQueue(int n) {
        AtomicReferenceArray atomicReferenceArray;
        RangeUtil.checkGreaterThanOrEqual(n, 2, "initialCapacity");
        int n2 = Pow2.roundToPowerOfTwo(n);
        long l = n2 - 1 << 1;
        this.producerBuffer = atomicReferenceArray = AtomicQueueUtil.allocateRefArray(n2 + 1);
        this.producerMask = l;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l;
        this.soProducerLimit(l);
    }

    @Override
    public int size() {
        long l;
        long l2;
        long l3 = this.lvConsumerIndex();
        do {
            l2 = l3;
            l = this.lvProducerIndex();
        } while (l2 != (l3 = this.lvConsumerIndex()));
        long l4 = l - l3 >> 1;
        if (l4 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l4;
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e) {
        AtomicReferenceArray atomicReferenceArray;
        long l;
        long l2;
        if (null == e) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long l3 = this.lvProducerLimit();
            l2 = this.lvProducerIndex();
            if ((l2 & 1L) == 1L) continue;
            l = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            if (l3 <= l2) {
                int n = this.offerSlowPath(l, l2, l3);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l, atomicReferenceArray, l2, e, null);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l2, l2 + 2L)) break;
        }
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, e);
        return true;
    }

    @Override
    public E poll() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null) {
            if (l2 != this.lvProducerIndex()) {
                while ((e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.nextBuffer(atomicReferenceArray, l);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l2 + 2L);
        return e;
    }

    @Override
    public E peek() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null && l2 != this.lvProducerIndex()) {
            while ((e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n)) == null) {
            }
        }
        if (e == JUMP) {
            return this.newBufferPeek(this.nextBuffer(atomicReferenceArray, l), l2);
        }
        return e;
    }

    private int offerSlowPath(long l, long l2, long l3) {
        long l4;
        long l5 = this.lvConsumerIndex();
        if (l5 + (l4 = this.getCurrentBufferCapacity(l)) > l2) {
            if (!this.casProducerLimit(l3, l5 + l4)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l2, l5) <= 0L) {
            return 2;
        }
        if (this.casProducerIndex(l2, l2 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private AtomicReferenceArray<E> nextBuffer(AtomicReferenceArray<E> atomicReferenceArray, long l) {
        AtomicReferenceArray atomicReferenceArray2;
        int n = BaseMpscLinkedAtomicArrayQueue.nextArrayOffset(l);
        this.consumerBuffer = atomicReferenceArray2 = (AtomicReferenceArray)AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        this.consumerMask = AtomicQueueUtil.length(atomicReferenceArray2) - 2 << 1;
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, BUFFER_CONSUMED);
        return atomicReferenceArray2;
    }

    private static int nextArrayOffset(long l) {
        return AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(AtomicReferenceArray<E> atomicReferenceArray, long l) {
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        E e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l + 2L);
        return e;
    }

    private E newBufferPeek(AtomicReferenceArray<E> atomicReferenceArray, long l) {
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        E e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (null == e) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.nextBuffer(atomicReferenceArray, l);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n, null);
        this.soConsumerIndex(l2 + 2L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        long l;
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        int n = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n);
        if (e == JUMP) {
            return this.newBufferPeek(this.nextBuffer(atomicReferenceArray, l), l2);
        }
        return e;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n;
        long l = 0L;
        int n2 = this.capacity();
        do {
            if ((n = this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l;
        } while ((l += (long)n) <= (long)n2);
        return (int)l;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n) {
        long l;
        AtomicReferenceArray atomicReferenceArray;
        long l2;
        long l3;
        if (null == messagePassingQueue$Supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        block5: while (true) {
            long l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            l = Math.min(l4, l3 + 2L * (long)n);
            if (l3 >= l4) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l2, atomicReferenceArray, l3, null, messagePassingQueue$Supplier);
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l3, l)) break;
        }
        int n3 = (int)((l - l3) / 2L);
        for (int i = 0; i < n3; ++i) {
            int n4 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l3 + 2L * (long)i, l2);
            AtomicQueueUtil.soRefElement(atomicReferenceArray, n4, messagePassingQueue$Supplier.get());
        }
        return n3;
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        MessagePassingQueueUtil.fill(this, messagePassingQueue$Supplier, messagePassingQueue$WaitStrategy, messagePassingQueue$ExitCondition);
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n) {
        return MessagePassingQueueUtil.drain(this, messagePassingQueue$Consumer, n);
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        MessagePassingQueueUtil.drain(this, messagePassingQueue$Consumer, messagePassingQueue$WaitStrategy, messagePassingQueue$ExitCondition);
    }

    @Override
    public Iterator<E> iterator() {
        return new BaseMpscLinkedAtomicArrayQueue$WeakIterator(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    private void resize(long l, AtomicReferenceArray<E> atomicReferenceArray, long l2, E e, MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        AtomicReferenceArray atomicReferenceArray2;
        assert (e != null && messagePassingQueue$Supplier == null || e == null || messagePassingQueue$Supplier != null);
        int n = this.getNextBufferSize(atomicReferenceArray);
        try {
            atomicReferenceArray2 = AtomicQueueUtil.allocateRefArray(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            assert (this.lvProducerIndex() == l2 + 1L);
            this.soProducerIndex(l2);
            throw outOfMemoryError;
        }
        this.producerBuffer = atomicReferenceArray2;
        int n2 = n - 2 << 1;
        this.producerMask = n2;
        int n3 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        int n4 = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(l2, n2);
        AtomicQueueUtil.soRefElement(atomicReferenceArray2, n4, e == null ? messagePassingQueue$Supplier.get() : e);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, BaseMpscLinkedAtomicArrayQueue.nextArrayOffset(l), atomicReferenceArray2);
        long l3 = this.lvConsumerIndex();
        long l4 = this.availableInQueue(l2, l3);
        RangeUtil.checkPositive(l4, "availableInQueue");
        this.soProducerLimit(l2 + Math.min((long)n2, l4));
        this.soProducerIndex(l2 + 2L);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n3, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    static /* synthetic */ Object access$000() {
        return JUMP;
    }

    static /* synthetic */ Object access$100() {
        return BUFFER_CONSUMED;
    }
}

