/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm;

import pro.gravit.repackage.org.objectweb.asm.AnnotationVisitor;
import pro.gravit.repackage.org.objectweb.asm.ByteVector;
import pro.gravit.repackage.org.objectweb.asm.Symbol;
import pro.gravit.repackage.org.objectweb.asm.SymbolTable;
import pro.gravit.repackage.org.objectweb.asm.Type;
import pro.gravit.repackage.org.objectweb.asm.TypePath;
import pro.gravit.repackage.org.objectweb.asm.TypeReference;

final class AnnotationWriter
extends AnnotationVisitor {
    private final SymbolTable symbolTable;
    private final boolean useNamedValues;
    private final ByteVector annotation;
    private final int numElementValuePairsOffset;
    private int numElementValuePairs;
    private final AnnotationWriter previousAnnotation;
    private AnnotationWriter nextAnnotation;

    AnnotationWriter(SymbolTable symbolTable, boolean bl, ByteVector byteVector, AnnotationWriter annotationWriter) {
        super(589824);
        this.symbolTable = symbolTable;
        this.useNamedValues = bl;
        this.annotation = byteVector;
        this.numElementValuePairsOffset = byteVector.length == 0 ? -1 : byteVector.length - 2;
        this.previousAnnotation = annotationWriter;
        if (annotationWriter != null) {
            annotationWriter.nextAnnotation = this;
        }
    }

    static AnnotationWriter create(SymbolTable symbolTable, String string, AnnotationWriter annotationWriter) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(symbolTable.addConstantUtf8(string)).putShort(0);
        return new AnnotationWriter(symbolTable, true, byteVector, annotationWriter);
    }

    static AnnotationWriter create(SymbolTable symbolTable, int n, TypePath typePath, String string, AnnotationWriter annotationWriter) {
        ByteVector byteVector = new ByteVector();
        TypeReference.putTarget(n, byteVector);
        TypePath.put(typePath, byteVector);
        byteVector.putShort(symbolTable.addConstantUtf8(string)).putShort(0);
        return new AnnotationWriter(symbolTable, true, byteVector, annotationWriter);
    }

    @Override
    public void visit(String string, Object object) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        if (object instanceof String) {
            this.annotation.put12(115, this.symbolTable.addConstantUtf8((String)object));
        } else if (object instanceof Byte) {
            this.annotation.put12(66, this.symbolTable.addConstantInteger((int)((Byte)object).byteValue()).index);
        } else if (object instanceof Boolean) {
            int n = (Boolean)object != false ? 1 : 0;
            this.annotation.put12(90, this.symbolTable.addConstantInteger((int)n).index);
        } else if (object instanceof Character) {
            this.annotation.put12(67, this.symbolTable.addConstantInteger((int)((Character)object).charValue()).index);
        } else if (object instanceof Short) {
            this.annotation.put12(83, this.symbolTable.addConstantInteger((int)((Short)object).shortValue()).index);
        } else if (object instanceof Type) {
            this.annotation.put12(99, this.symbolTable.addConstantUtf8(((Type)object).getDescriptor()));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.annotation.put12(91, byArray.length);
            for (byte by : byArray) {
                this.annotation.put12(66, this.symbolTable.addConstantInteger((int)by).index);
            }
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            this.annotation.put12(91, blArray.length);
            for (boolean bl : blArray) {
                this.annotation.put12(90, this.symbolTable.addConstantInteger((int)(bl ? 1 : 0)).index);
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            this.annotation.put12(91, sArray.length);
            for (short s : sArray) {
                this.annotation.put12(83, this.symbolTable.addConstantInteger((int)s).index);
            }
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            this.annotation.put12(91, cArray.length);
            for (char c : cArray) {
                this.annotation.put12(67, this.symbolTable.addConstantInteger((int)c).index);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            this.annotation.put12(91, nArray.length);
            for (int n : nArray) {
                this.annotation.put12(73, this.symbolTable.addConstantInteger((int)n).index);
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            this.annotation.put12(91, lArray.length);
            for (long l : lArray) {
                this.annotation.put12(74, this.symbolTable.addConstantLong((long)l).index);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            this.annotation.put12(91, fArray.length);
            for (float f : fArray) {
                this.annotation.put12(70, this.symbolTable.addConstantFloat((float)f).index);
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            this.annotation.put12(91, dArray.length);
            for (double d : dArray) {
                this.annotation.put12(68, this.symbolTable.addConstantDouble((double)d).index);
            }
        } else {
            Symbol symbol = this.symbolTable.addConstant(object);
            this.annotation.put12(".s.IFJDCS".charAt(symbol.tag), symbol.index);
        }
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(101, this.symbolTable.addConstantUtf8(string2)).putShort(this.symbolTable.addConstantUtf8(string3));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(64, this.symbolTable.addConstantUtf8(string2)).putShort(0);
        return new AnnotationWriter(this.symbolTable, true, this.annotation, null);
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(91, 0);
        return new AnnotationWriter(this.symbolTable, false, this.annotation, null);
    }

    @Override
    public void visitEnd() {
        if (this.numElementValuePairsOffset != -1) {
            byte[] byArray = this.annotation.data;
            byArray[this.numElementValuePairsOffset] = (byte)(this.numElementValuePairs >>> 8);
            byArray[this.numElementValuePairsOffset + 1] = (byte)this.numElementValuePairs;
        }
    }

    int computeAnnotationsSize(String string) {
        if (string != null) {
            this.symbolTable.addConstantUtf8(string);
        }
        int n = 8;
        AnnotationWriter annotationWriter = this;
        while (annotationWriter != null) {
            n += annotationWriter.annotation.length;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        return n;
    }

    static int computeAnnotationsSize(AnnotationWriter annotationWriter, AnnotationWriter annotationWriter2, AnnotationWriter annotationWriter3, AnnotationWriter annotationWriter4) {
        int n = 0;
        if (annotationWriter != null) {
            n += annotationWriter.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (annotationWriter2 != null) {
            n += annotationWriter2.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (annotationWriter3 != null) {
            n += annotationWriter3.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (annotationWriter4 != null) {
            n += annotationWriter4.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        return n;
    }

    void putAnnotations(int n, ByteVector byteVector) {
        int n2 = 2;
        int n3 = 0;
        AnnotationWriter annotationWriter = this;
        AnnotationWriter annotationWriter2 = null;
        while (annotationWriter != null) {
            annotationWriter.visitEnd();
            n2 += annotationWriter.annotation.length;
            ++n3;
            annotationWriter2 = annotationWriter;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        byteVector.putShort(n);
        byteVector.putInt(n2);
        byteVector.putShort(n3);
        annotationWriter = annotationWriter2;
        while (annotationWriter != null) {
            byteVector.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
            annotationWriter = annotationWriter.nextAnnotation;
        }
    }

    static void putAnnotations(SymbolTable symbolTable, AnnotationWriter annotationWriter, AnnotationWriter annotationWriter2, AnnotationWriter annotationWriter3, AnnotationWriter annotationWriter4, ByteVector byteVector) {
        if (annotationWriter != null) {
            annotationWriter.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleAnnotations"), byteVector);
        }
        if (annotationWriter2 != null) {
            annotationWriter2.putAnnotations(symbolTable.addConstantUtf8("RuntimeInvisibleAnnotations"), byteVector);
        }
        if (annotationWriter3 != null) {
            annotationWriter3.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), byteVector);
        }
        if (annotationWriter4 != null) {
            annotationWriter4.putAnnotations(symbolTable.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), byteVector);
        }
    }

    static int computeParameterAnnotationsSize(String string, AnnotationWriter[] annotationWriterArray, int n) {
        int n2 = 7 + 2 * n;
        for (int i = 0; i < n; ++i) {
            AnnotationWriter annotationWriter = annotationWriterArray[i];
            n2 += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(string) - 8;
        }
        return n2;
    }

    static void putParameterAnnotations(int n, AnnotationWriter[] annotationWriterArray, int n2, ByteVector byteVector) {
        AnnotationWriter annotationWriter;
        int n3;
        int n4 = 1 + 2 * n2;
        for (n3 = 0; n3 < n2; ++n3) {
            annotationWriter = annotationWriterArray[n3];
            n4 += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(null) - 8;
        }
        byteVector.putShort(n);
        byteVector.putInt(n4);
        byteVector.putByte(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            annotationWriter = annotationWriterArray[n3];
            AnnotationWriter annotationWriter2 = null;
            int n5 = 0;
            while (annotationWriter != null) {
                annotationWriter.visitEnd();
                ++n5;
                annotationWriter2 = annotationWriter;
                annotationWriter = annotationWriter.previousAnnotation;
            }
            byteVector.putShort(n5);
            annotationWriter = annotationWriter2;
            while (annotationWriter != null) {
                byteVector.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
                annotationWriter = annotationWriter.nextAnnotation;
            }
        }
    }
}

