/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm;

import pro.gravit.repackage.org.objectweb.asm.ByteVector;
import pro.gravit.repackage.org.objectweb.asm.ClassReader;
import pro.gravit.repackage.org.objectweb.asm.ClassWriter;
import pro.gravit.repackage.org.objectweb.asm.Label;
import pro.gravit.repackage.org.objectweb.asm.SymbolTable;

public class Attribute {
    public final String type;
    private byte[] content;
    Attribute nextAttribute;

    protected Attribute(String string) {
        this.type = string;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return new Label[0];
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        Attribute attribute = new Attribute(this.type);
        attribute.content = new byte[n2];
        System.arraycopy(classReader.classFileBuffer, n, attribute.content, 0, n2);
        return attribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        return new ByteVector(this.content);
    }

    final int getAttributeCount() {
        int n = 0;
        Attribute attribute = this;
        while (attribute != null) {
            ++n;
            attribute = attribute.nextAttribute;
        }
        return n;
    }

    final int computeAttributesSize(SymbolTable symbolTable) {
        byte[] byArray = null;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        return this.computeAttributesSize(symbolTable, byArray, 0, -1, -1);
    }

    final int computeAttributesSize(SymbolTable symbolTable, byte[] byArray, int n, int n2, int n3) {
        ClassWriter classWriter = symbolTable.classWriter;
        int n4 = 0;
        Attribute attribute = this;
        while (attribute != null) {
            symbolTable.addConstantUtf8(attribute.type);
            n4 += 6 + attribute.write((ClassWriter)classWriter, (byte[])byArray, (int)n, (int)n2, (int)n3).length;
            attribute = attribute.nextAttribute;
        }
        return n4;
    }

    static int computeAttributesSize(SymbolTable symbolTable, int n, int n2) {
        int n3 = 0;
        if ((n & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            symbolTable.addConstantUtf8("Synthetic");
            n3 += 6;
        }
        if (n2 != 0) {
            symbolTable.addConstantUtf8("Signature");
            n3 += 8;
        }
        if ((n & 0x20000) != 0) {
            symbolTable.addConstantUtf8("Deprecated");
            n3 += 6;
        }
        return n3;
    }

    final void putAttributes(SymbolTable symbolTable, ByteVector byteVector) {
        byte[] byArray = null;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        this.putAttributes(symbolTable, byArray, 0, -1, -1, byteVector);
    }

    final void putAttributes(SymbolTable symbolTable, byte[] byArray, int n, int n2, int n3, ByteVector byteVector) {
        ClassWriter classWriter = symbolTable.classWriter;
        Attribute attribute = this;
        while (attribute != null) {
            ByteVector byteVector2 = attribute.write(classWriter, byArray, n, n2, n3);
            byteVector.putShort(symbolTable.addConstantUtf8(attribute.type)).putInt(byteVector2.length);
            byteVector.putByteArray(byteVector2.data, 0, byteVector2.length);
            attribute = attribute.nextAttribute;
        }
    }

    static void putAttributes(SymbolTable symbolTable, int n, int n2, ByteVector byteVector) {
        if ((n & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            byteVector.putShort(symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (n2 != 0) {
            byteVector.putShort(symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(n2);
        }
        if ((n & 0x20000) != 0) {
            byteVector.putShort(symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
    }
}

