/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import pro.gravit.repackage.org.objectweb.asm.AnnotationVisitor;
import pro.gravit.repackage.org.objectweb.asm.Attribute;
import pro.gravit.repackage.org.objectweb.asm.ClassVisitor;
import pro.gravit.repackage.org.objectweb.asm.ConstantDynamic;
import pro.gravit.repackage.org.objectweb.asm.Context;
import pro.gravit.repackage.org.objectweb.asm.FieldVisitor;
import pro.gravit.repackage.org.objectweb.asm.Handle;
import pro.gravit.repackage.org.objectweb.asm.Label;
import pro.gravit.repackage.org.objectweb.asm.MethodVisitor;
import pro.gravit.repackage.org.objectweb.asm.MethodWriter;
import pro.gravit.repackage.org.objectweb.asm.ModuleVisitor;
import pro.gravit.repackage.org.objectweb.asm.Opcodes;
import pro.gravit.repackage.org.objectweb.asm.RecordComponentVisitor;
import pro.gravit.repackage.org.objectweb.asm.Type;
import pro.gravit.repackage.org.objectweb.asm.TypePath;

public class ClassReader {
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    static final int EXPAND_ASM_INSNS = 256;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int INPUT_STREAM_DATA_CHUNK_SIZE = 4096;
    @Deprecated
    public final byte[] b;
    public final int header;
    final byte[] classFileBuffer;
    private final int[] cpInfoOffsets;
    private final String[] constantUtf8Values;
    private final ConstantDynamic[] constantDynamicValues;
    private final int[] bootstrapMethodOffsets;
    private final int maxStringLength;

    public ClassReader(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ClassReader(byte[] byArray, int n, int n2) {
        this(byArray, n, true);
    }

    ClassReader(byte[] byArray, int n, boolean bl) {
        this.classFileBuffer = byArray;
        this.b = byArray;
        if (bl && this.readShort(n + 6) > 62) {
            throw new IllegalArgumentException("Unsupported class file major version " + this.readShort(n + 6));
        }
        int n2 = this.readUnsignedShort(n + 8);
        this.cpInfoOffsets = new int[n2];
        this.constantUtf8Values = new String[n2];
        int n3 = 1;
        int n4 = n + 10;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n3 < n2) {
            int n6;
            this.cpInfoOffsets[n3++] = n4 + 1;
            switch (byArray[n4]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n6 = 5;
                    break;
                }
                case 17: {
                    n6 = 5;
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 18: {
                    n6 = 5;
                    bl2 = true;
                    break;
                }
                case 5: 
                case 6: {
                    n6 = 9;
                    ++n3;
                    break;
                }
                case 1: {
                    n6 = 3 + this.readUnsignedShort(n4 + 1);
                    if (n6 <= n5) break;
                    n5 = n6;
                    break;
                }
                case 15: {
                    n6 = 4;
                    break;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    n6 = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            n4 += n6;
        }
        this.maxStringLength = n5;
        this.header = n4;
        this.constantDynamicValues = bl3 ? new ConstantDynamic[n2] : null;
        this.bootstrapMethodOffsets = bl2 ? this.readBootstrapMethodsAttribute(n5) : null;
    }

    public ClassReader(InputStream inputStream) {
        this(ClassReader.readStream(inputStream, false));
    }

    public ClassReader(String string) {
        this(ClassReader.readStream(ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".class"), true));
    }

    private static byte[] readStream(InputStream inputStream, boolean bl) {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        int n = ClassReader.calculateBufferSize(inputStream);
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            block13: {
                byte[] byArray;
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    int n2;
                    byte[] byArray2 = new byte[n];
                    int n3 = 0;
                    while ((n2 = inputStream.read(byArray2, 0, n)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n2);
                        ++n3;
                    }
                    byteArrayOutputStream.flush();
                    if (n3 != true) break block13;
                    byArray = byArray2;
                }
                catch (Throwable throwable) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                byteArrayOutputStream.close();
                return byArray;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        finally {
            if (bl) {
                inputStream.close();
            }
        }
    }

    private static int calculateBufferSize(InputStream inputStream) {
        int n = inputStream.available();
        if (n < 256) {
            return 4096;
        }
        return Math.min(n, 0x100000);
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    public String getSuperName() {
        return this.readClass(this.header + 4, new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int n = this.header + 6;
        int n2 = this.readUnsignedShort(n);
        String[] stringArray = new String[n2];
        if (n2 > 0) {
            char[] cArray = new char[this.maxStringLength];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = this.readClass(n += 2, cArray);
            }
        }
        return stringArray;
    }

    public void accept(ClassVisitor classVisitor, int n) {
        this.accept(classVisitor, new Attribute[0], n);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attributeArray, int n) {
        Object object;
        int n2;
        int n3;
        Context context = new Context();
        context.attributePrototypes = attributeArray;
        context.parsingOptions = n;
        char[] cArray = context.charBuffer = new char[this.maxStringLength];
        int n4 = this.header;
        int n5 = this.readUnsignedShort(n4);
        String string = this.readClass(n4 + 2, cArray);
        String string2 = this.readClass(n4 + 4, cArray);
        String[] stringArray = new String[this.readUnsignedShort(n4 + 6)];
        n4 += 8;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = this.readClass(n4, cArray);
            n4 += 2;
        }
        n3 = 0;
        int n6 = 0;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        String string6 = null;
        String string7 = null;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        Object object2 = null;
        int n16 = this.getFirstAttributeOffset();
        for (n2 = this.readUnsignedShort(n16 - 2); n2 > 0; --n2) {
            String string8 = this.readUTF8(n16, cArray);
            int n17 = this.readInt(n16 + 2);
            n16 += 6;
            if ("SourceFile".equals(string8)) {
                string4 = this.readUTF8(n16, cArray);
            } else if ("InnerClasses".equals(string8)) {
                n3 = n16;
            } else if ("EnclosingMethod".equals(string8)) {
                n6 = n16;
            } else if ("NestHost".equals(string8)) {
                string7 = this.readClass(n16, cArray);
            } else if ("NestMembers".equals(string8)) {
                n13 = n16;
            } else if ("PermittedSubclasses".equals(string8)) {
                n14 = n16;
            } else if ("Signature".equals(string8)) {
                string3 = this.readUTF8(n16, cArray);
            } else if ("RuntimeVisibleAnnotations".equals(string8)) {
                n7 = n16;
            } else if ("RuntimeVisibleTypeAnnotations".equals(string8)) {
                n9 = n16;
            } else if ("Deprecated".equals(string8)) {
                n5 |= 0x20000;
            } else if ("Synthetic".equals(string8)) {
                n5 |= 0x1000;
            } else if ("SourceDebugExtension".equals(string8)) {
                if (n17 > this.classFileBuffer.length - n16) {
                    throw new IllegalArgumentException();
                }
                string5 = this.readUtf(n16, n17, new char[n17]);
            } else if ("RuntimeInvisibleAnnotations".equals(string8)) {
                n8 = n16;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(string8)) {
                n10 = n16;
            } else if ("Record".equals(string8)) {
                n15 = n16;
                n5 |= 0x10000;
            } else if ("Module".equals(string8)) {
                n11 = n16;
            } else if ("ModuleMainClass".equals(string8)) {
                string6 = this.readClass(n16, cArray);
            } else if ("ModulePackages".equals(string8)) {
                n12 = n16;
            } else if (!"BootstrapMethods".equals(string8)) {
                object = this.readAttribute(attributeArray, string8, n16, n17, cArray, -1, null);
                ((Attribute)object).nextAttribute = object2;
                object2 = object;
            }
            n16 += n17;
        }
        classVisitor.visit(this.readInt(this.cpInfoOffsets[1] - 7), n5, string, string3, string2, stringArray);
        if ((n & 2) == 0 && (string4 != null || string5 != null)) {
            classVisitor.visitSource(string4, string5);
        }
        if (n11 != 0) {
            this.readModuleAttributes(classVisitor, context, n11, n12, string6);
        }
        if (string7 != null) {
            classVisitor.visitNestHost(string7);
        }
        if (n6 != 0) {
            String string9 = this.readClass(n6, cArray);
            int n18 = this.readUnsignedShort(n6 + 2);
            String string10 = n18 == 0 ? null : this.readUTF8(this.cpInfoOffsets[n18], cArray);
            object = n18 == 0 ? null : this.readUTF8(this.cpInfoOffsets[n18] + 2, cArray);
            classVisitor.visitOuterClass(string9, string10, (String)object);
        }
        if (n7 != 0) {
            n2 = this.readUnsignedShort(n7);
            int n19 = n7 + 2;
            while (n2-- > 0) {
                String string11 = this.readUTF8(n19, cArray);
                n19 += 2;
                n19 = this.readElementValues(classVisitor.visitAnnotation(string11, true), n19, true, cArray);
            }
        }
        if (n8 != 0) {
            n2 = this.readUnsignedShort(n8);
            int n20 = n8 + 2;
            while (n2-- > 0) {
                String string12 = this.readUTF8(n20, cArray);
                n20 += 2;
                n20 = this.readElementValues(classVisitor.visitAnnotation(string12, false), n20, true, cArray);
            }
        }
        if (n9 != 0) {
            n2 = this.readUnsignedShort(n9);
            int n21 = n9 + 2;
            while (n2-- > 0) {
                n21 = this.readTypeAnnotationTarget(context, n21);
                String string13 = this.readUTF8(n21, cArray);
                n21 += 2;
                n21 = this.readElementValues(classVisitor.visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string13, true), n21, true, cArray);
            }
        }
        if (n10 != 0) {
            n2 = this.readUnsignedShort(n10);
            int n22 = n10 + 2;
            while (n2-- > 0) {
                n22 = this.readTypeAnnotationTarget(context, n22);
                String string14 = this.readUTF8(n22, cArray);
                n22 += 2;
                n22 = this.readElementValues(classVisitor.visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string14, false), n22, true, cArray);
            }
        }
        while (object2 != null) {
            Attribute attribute = ((Attribute)object2).nextAttribute;
            ((Attribute)object2).nextAttribute = null;
            classVisitor.visitAttribute((Attribute)object2);
            object2 = attribute;
        }
        if (n13 != 0) {
            n2 = this.readUnsignedShort(n13);
            int n23 = n13 + 2;
            while (n2-- > 0) {
                classVisitor.visitNestMember(this.readClass(n23, cArray));
                n23 += 2;
            }
        }
        if (n14 != 0) {
            n2 = this.readUnsignedShort(n14);
            int n24 = n14 + 2;
            while (n2-- > 0) {
                classVisitor.visitPermittedSubclass(this.readClass(n24, cArray));
                n24 += 2;
            }
        }
        if (n3 != 0) {
            n2 = this.readUnsignedShort(n3);
            int n25 = n3 + 2;
            while (n2-- > 0) {
                classVisitor.visitInnerClass(this.readClass(n25, cArray), this.readClass(n25 + 2, cArray), this.readUTF8(n25 + 4, cArray), this.readUnsignedShort(n25 + 6));
                n25 += 8;
            }
        }
        if (n15 != 0) {
            n2 = this.readUnsignedShort(n15);
            n15 += 2;
            while (n2-- > 0) {
                n15 = this.readRecordComponent(classVisitor, context, n15);
            }
        }
        n2 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n2-- > 0) {
            n4 = this.readField(classVisitor, context, n4);
        }
        int n26 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n26-- > 0) {
            n4 = this.readMethod(classVisitor, context, n4);
        }
        classVisitor.visitEnd();
    }

    private void readModuleAttributes(ClassVisitor classVisitor, Context context, int n, int n2, String string) {
        int n3;
        int n4;
        int n5;
        char[] cArray = context.charBuffer;
        int n6 = n;
        String string2 = this.readModule(n6, cArray);
        int n7 = this.readUnsignedShort(n6 + 2);
        String string3 = this.readUTF8(n6 + 4, cArray);
        n6 += 6;
        ModuleVisitor moduleVisitor = classVisitor.visitModule(string2, n7, string3);
        if (moduleVisitor == null) {
            return;
        }
        if (string != null) {
            moduleVisitor.visitMainClass(string);
        }
        if (n2 != 0) {
            n5 = this.readUnsignedShort(n2);
            n4 = n2 + 2;
            while (n5-- > 0) {
                moduleVisitor.visitPackage(this.readPackage(n4, cArray));
                n4 += 2;
            }
        }
        n5 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n5-- > 0) {
            String string4 = this.readModule(n6, cArray);
            int n8 = this.readUnsignedShort(n6 + 2);
            String string5 = this.readUTF8(n6 + 4, cArray);
            n6 += 6;
            moduleVisitor.visitRequire(string4, n8, string5);
        }
        n4 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n4-- > 0) {
            String string6 = this.readPackage(n6, cArray);
            int n9 = this.readUnsignedShort(n6 + 2);
            n3 = this.readUnsignedShort(n6 + 4);
            n6 += 6;
            String[] stringArray = null;
            if (n3 != 0) {
                stringArray = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    stringArray[i] = this.readModule(n6, cArray);
                    n6 += 2;
                }
            }
            moduleVisitor.visitExport(string6, n9, stringArray);
        }
        int n10 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n10-- > 0) {
            String string7 = this.readPackage(n6, cArray);
            n3 = this.readUnsignedShort(n6 + 2);
            int n11 = this.readUnsignedShort(n6 + 4);
            n6 += 6;
            String[] stringArray = null;
            if (n11 != 0) {
                stringArray = new String[n11];
                for (int i = 0; i < n11; ++i) {
                    stringArray[i] = this.readModule(n6, cArray);
                    n6 += 2;
                }
            }
            moduleVisitor.visitOpen(string7, n3, stringArray);
        }
        int n12 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n12-- > 0) {
            moduleVisitor.visitUse(this.readClass(n6, cArray));
            n6 += 2;
        }
        n3 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n3-- > 0) {
            String string8 = this.readClass(n6, cArray);
            int n13 = this.readUnsignedShort(n6 + 2);
            n6 += 4;
            String[] stringArray = new String[n13];
            for (int i = 0; i < n13; ++i) {
                stringArray[i] = this.readClass(n6, cArray);
                n6 += 2;
            }
            moduleVisitor.visitProvide(string8, stringArray);
        }
        moduleVisitor.visitEnd();
    }

    private int readRecordComponent(ClassVisitor classVisitor, Context context, int n) {
        String string;
        int n2;
        Object object;
        char[] cArray = context.charBuffer;
        int n3 = n;
        String string2 = this.readUTF8(n3, cArray);
        String string3 = this.readUTF8(n3 + 2, cArray);
        n3 += 4;
        String string4 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Attribute attribute = null;
        int n8 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n8-- > 0) {
            object = this.readUTF8(n3, cArray);
            n2 = this.readInt(n3 + 2);
            n3 += 6;
            if ("Signature".equals(object)) {
                string4 = this.readUTF8(n3, cArray);
            } else if ("RuntimeVisibleAnnotations".equals(object)) {
                n4 = n3;
            } else if ("RuntimeVisibleTypeAnnotations".equals(object)) {
                n6 = n3;
            } else if ("RuntimeInvisibleAnnotations".equals(object)) {
                n5 = n3;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(object)) {
                n7 = n3;
            } else {
                Attribute attribute2 = this.readAttribute(context.attributePrototypes, (String)object, n3, n2, cArray, -1, null);
                attribute2.nextAttribute = attribute;
                attribute = attribute2;
            }
            n3 += n2;
        }
        object = classVisitor.visitRecordComponent(string2, string3, string4);
        if (object == null) {
            return n3;
        }
        if (n4 != 0) {
            n2 = this.readUnsignedShort(n4);
            int n9 = n4 + 2;
            while (n2-- > 0) {
                string = this.readUTF8(n9, cArray);
                n9 += 2;
                n9 = this.readElementValues(((RecordComponentVisitor)object).visitAnnotation(string, true), n9, true, cArray);
            }
        }
        if (n5 != 0) {
            n2 = this.readUnsignedShort(n5);
            int n10 = n5 + 2;
            while (n2-- > 0) {
                string = this.readUTF8(n10, cArray);
                n10 += 2;
                n10 = this.readElementValues(((RecordComponentVisitor)object).visitAnnotation(string, false), n10, true, cArray);
            }
        }
        if (n6 != 0) {
            n2 = this.readUnsignedShort(n6);
            int n11 = n6 + 2;
            while (n2-- > 0) {
                n11 = this.readTypeAnnotationTarget(context, n11);
                string = this.readUTF8(n11, cArray);
                n11 += 2;
                n11 = this.readElementValues(((RecordComponentVisitor)object).visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string, true), n11, true, cArray);
            }
        }
        if (n7 != 0) {
            n2 = this.readUnsignedShort(n7);
            int n12 = n7 + 2;
            while (n2-- > 0) {
                n12 = this.readTypeAnnotationTarget(context, n12);
                string = this.readUTF8(n12, cArray);
                n12 += 2;
                n12 = this.readElementValues(((RecordComponentVisitor)object).visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string, false), n12, true, cArray);
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.nextAttribute;
            attribute.nextAttribute = null;
            ((RecordComponentVisitor)object).visitAttribute(attribute);
            attribute = attribute3;
        }
        ((RecordComponentVisitor)object).visitEnd();
        return n3;
    }

    private int readField(ClassVisitor classVisitor, Context context, int n) {
        String string;
        int n2;
        int n3;
        Object object;
        char[] cArray = context.charBuffer;
        int n4 = n;
        int n5 = this.readUnsignedShort(n4);
        String string2 = this.readUTF8(n4 + 2, cArray);
        String string3 = this.readUTF8(n4 + 4, cArray);
        n4 += 6;
        Object object2 = null;
        String string4 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Attribute attribute = null;
        int n10 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n10-- > 0) {
            object = this.readUTF8(n4, cArray);
            n3 = this.readInt(n4 + 2);
            n4 += 6;
            if ("ConstantValue".equals(object)) {
                n2 = this.readUnsignedShort(n4);
                object2 = n2 == 0 ? null : this.readConst(n2, cArray);
            } else if ("Signature".equals(object)) {
                string4 = this.readUTF8(n4, cArray);
            } else if ("Deprecated".equals(object)) {
                n5 |= 0x20000;
            } else if ("Synthetic".equals(object)) {
                n5 |= 0x1000;
            } else if ("RuntimeVisibleAnnotations".equals(object)) {
                n6 = n4;
            } else if ("RuntimeVisibleTypeAnnotations".equals(object)) {
                n8 = n4;
            } else if ("RuntimeInvisibleAnnotations".equals(object)) {
                n7 = n4;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(object)) {
                n9 = n4;
            } else {
                Attribute attribute2 = this.readAttribute(context.attributePrototypes, (String)object, n4, n3, cArray, -1, null);
                attribute2.nextAttribute = attribute;
                attribute = attribute2;
            }
            n4 += n3;
        }
        object = classVisitor.visitField(n5, string2, string3, string4, object2);
        if (object == null) {
            return n4;
        }
        if (n6 != 0) {
            n3 = this.readUnsignedShort(n6);
            n2 = n6 + 2;
            while (n3-- > 0) {
                string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((FieldVisitor)object).visitAnnotation(string, true), n2, true, cArray);
            }
        }
        if (n7 != 0) {
            n3 = this.readUnsignedShort(n7);
            n2 = n7 + 2;
            while (n3-- > 0) {
                string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((FieldVisitor)object).visitAnnotation(string, false), n2, true, cArray);
            }
        }
        if (n8 != 0) {
            n3 = this.readUnsignedShort(n8);
            n2 = n8 + 2;
            while (n3-- > 0) {
                n2 = this.readTypeAnnotationTarget(context, n2);
                string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((FieldVisitor)object).visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string, true), n2, true, cArray);
            }
        }
        if (n9 != 0) {
            n3 = this.readUnsignedShort(n9);
            n2 = n9 + 2;
            while (n3-- > 0) {
                n2 = this.readTypeAnnotationTarget(context, n2);
                string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((FieldVisitor)object).visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string, false), n2, true, cArray);
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.nextAttribute;
            attribute.nextAttribute = null;
            ((FieldVisitor)object).visitAttribute(attribute);
            attribute = attribute3;
        }
        ((FieldVisitor)object).visitEnd();
        return n4;
    }

    private int readMethod(ClassVisitor classVisitor, Context context, int n) {
        MethodWriter methodWriter;
        int n2;
        Object object;
        char[] cArray = context.charBuffer;
        int n3 = n;
        context.currentMethodAccessFlags = this.readUnsignedShort(n3);
        context.currentMethodName = this.readUTF8(n3 + 2, cArray);
        context.currentMethodDescriptor = this.readUTF8(n3 + 4, cArray);
        n3 += 6;
        int n4 = 0;
        int n5 = 0;
        String[] stringArray = null;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        Attribute attribute = null;
        int n15 = this.readUnsignedShort(n3);
        n3 += 2;
        while (n15-- > 0) {
            object = this.readUTF8(n3, cArray);
            int n16 = this.readInt(n3 + 2);
            n3 += 6;
            if ("Code".equals(object)) {
                if ((context.parsingOptions & 1) == 0) {
                    n4 = n3;
                }
            } else if ("Exceptions".equals(object)) {
                n5 = n3;
                stringArray = new String[this.readUnsignedShort(n5)];
                n2 = n5 + 2;
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.readClass(n2, cArray);
                    n2 += 2;
                }
            } else if ("Signature".equals(object)) {
                n6 = this.readUnsignedShort(n3);
            } else if ("Deprecated".equals(object)) {
                context.currentMethodAccessFlags |= 0x20000;
            } else if ("RuntimeVisibleAnnotations".equals(object)) {
                n7 = n3;
            } else if ("RuntimeVisibleTypeAnnotations".equals(object)) {
                n11 = n3;
            } else if ("AnnotationDefault".equals(object)) {
                n13 = n3;
            } else if ("Synthetic".equals(object)) {
                bl = true;
                context.currentMethodAccessFlags |= 0x1000;
            } else if ("RuntimeInvisibleAnnotations".equals(object)) {
                n8 = n3;
            } else if ("RuntimeInvisibleTypeAnnotations".equals(object)) {
                n12 = n3;
            } else if ("RuntimeVisibleParameterAnnotations".equals(object)) {
                n9 = n3;
            } else if ("RuntimeInvisibleParameterAnnotations".equals(object)) {
                n10 = n3;
            } else if ("MethodParameters".equals(object)) {
                n14 = n3;
            } else {
                Attribute attribute2 = this.readAttribute(context.attributePrototypes, (String)object, n3, n16, cArray, -1, null);
                attribute2.nextAttribute = attribute;
                attribute = attribute2;
            }
            n3 += n16;
        }
        object = classVisitor.visitMethod(context.currentMethodAccessFlags, context.currentMethodName, context.currentMethodDescriptor, n6 == 0 ? null : this.readUtf(n6, cArray), stringArray);
        if (object == null) {
            return n3;
        }
        if (object instanceof MethodWriter && (methodWriter = (MethodWriter)object).canCopyMethodAttributes(this, bl, (context.currentMethodAccessFlags & 0x20000) != 0, this.readUnsignedShort(n + 4), n6, n5)) {
            methodWriter.setMethodAttributesSource(n, n3 - n);
            return n3;
        }
        if (n14 != 0 && (context.parsingOptions & 2) == 0) {
            int n17 = this.readByte(n14);
            n2 = n14 + 1;
            while (n17-- > 0) {
                ((MethodVisitor)object).visitParameter(this.readUTF8(n2, cArray), this.readUnsignedShort(n2 + 2));
                n2 += 4;
            }
        }
        if (n13 != 0) {
            AnnotationVisitor annotationVisitor = ((MethodVisitor)object).visitAnnotationDefault();
            this.readElementValue(annotationVisitor, n13, null, cArray);
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
        if (n7 != 0) {
            int n18 = this.readUnsignedShort(n7);
            n2 = n7 + 2;
            while (n18-- > 0) {
                String string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((MethodVisitor)object).visitAnnotation(string, true), n2, true, cArray);
            }
        }
        if (n8 != 0) {
            int n19 = this.readUnsignedShort(n8);
            n2 = n8 + 2;
            while (n19-- > 0) {
                String string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((MethodVisitor)object).visitAnnotation(string, false), n2, true, cArray);
            }
        }
        if (n11 != 0) {
            int n20 = this.readUnsignedShort(n11);
            n2 = n11 + 2;
            while (n20-- > 0) {
                n2 = this.readTypeAnnotationTarget(context, n2);
                String string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((MethodVisitor)object).visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string, true), n2, true, cArray);
            }
        }
        if (n12 != 0) {
            int n21 = this.readUnsignedShort(n12);
            n2 = n12 + 2;
            while (n21-- > 0) {
                n2 = this.readTypeAnnotationTarget(context, n2);
                String string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(((MethodVisitor)object).visitTypeAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, string, false), n2, true, cArray);
            }
        }
        if (n9 != 0) {
            this.readParameterAnnotations((MethodVisitor)object, context, n9, true);
        }
        if (n10 != 0) {
            this.readParameterAnnotations((MethodVisitor)object, context, n10, false);
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.nextAttribute;
            attribute.nextAttribute = null;
            ((MethodVisitor)object).visitAttribute(attribute);
            attribute = attribute3;
        }
        if (n4 != 0) {
            ((MethodVisitor)object).visitCode();
            this.readCode((MethodVisitor)object, context, n4);
        }
        ((MethodVisitor)object).visitEnd();
        return n3;
    }

    private void readCode(MethodVisitor methodVisitor, Context context, int n) {
        int n2;
        Object object;
        int n3;
        boolean bl;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n;
        byte[] byArray = this.classFileBuffer;
        char[] cArray = context.charBuffer;
        int n10 = this.readUnsignedShort(n9);
        int n11 = this.readUnsignedShort(n9 + 2);
        int n12 = this.readInt(n9 + 4);
        if (n12 > this.classFileBuffer.length - (n9 += 8)) {
            throw new IllegalArgumentException();
        }
        int n13 = n9;
        int n14 = n9 + n12;
        context.currentMethodLabels = new Label[n12 + 1];
        Label[] labelArray = context.currentMethodLabels;
        block39: while (n9 < n14) {
            n8 = n9 - n13;
            int n15 = byArray[n9] & 0xFF;
            switch (n15) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    ++n9;
                    continue block39;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    this.createLabel(n8 + this.readShort(n9 + 1), labelArray);
                    n9 += 3;
                    continue block39;
                }
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: {
                    this.createLabel(n8 + this.readUnsignedShort(n9 + 1), labelArray);
                    n9 += 3;
                    continue block39;
                }
                case 200: 
                case 201: 
                case 220: {
                    this.createLabel(n8 + this.readInt(n9 + 1), labelArray);
                    n9 += 5;
                    continue block39;
                }
                case 196: {
                    switch (byArray[n9 + 1] & 0xFF) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: {
                            n9 += 4;
                            continue block39;
                        }
                        case 132: {
                            n9 += 6;
                            continue block39;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case 170: {
                    this.createLabel(n8 + this.readInt(n9 += 4 - (n8 & 3)), labelArray);
                    int n16 = this.readInt(n9 + 8) - this.readInt(n9 + 4) + 1;
                    n9 += 12;
                    while (n16-- > 0) {
                        this.createLabel(n8 + this.readInt(n9), labelArray);
                        n9 += 4;
                    }
                    continue block39;
                }
                case 171: {
                    this.createLabel(n8 + this.readInt(n9 += 4 - (n8 & 3)), labelArray);
                    int n17 = this.readInt(n9 + 4);
                    n9 += 8;
                    while (n17-- > 0) {
                        this.createLabel(n8 + this.readInt(n9 + 4), labelArray);
                        n9 += 8;
                    }
                    continue block39;
                }
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: 
                case 188: {
                    n9 += 2;
                    continue block39;
                }
                case 17: 
                case 19: 
                case 20: 
                case 132: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    n9 += 3;
                    continue block39;
                }
                case 185: 
                case 186: {
                    n9 += 5;
                    continue block39;
                }
                case 197: {
                    n9 += 4;
                    continue block39;
                }
            }
            throw new IllegalArgumentException();
        }
        n8 = this.readUnsignedShort(n9);
        n9 += 2;
        while (n8-- > 0) {
            Label label = this.createLabel(this.readUnsignedShort(n9), labelArray);
            Label label2 = this.createLabel(this.readUnsignedShort(n9 + 2), labelArray);
            Label label3 = this.createLabel(this.readUnsignedShort(n9 + 4), labelArray);
            String string = this.readUTF8(this.cpInfoOffsets[this.readUnsignedShort(n9 + 6)], cArray);
            n9 += 8;
            methodVisitor.visitTryCatchBlock(label, label2, label3, string);
        }
        int n18 = 0;
        int n19 = 0;
        boolean bl2 = true;
        int n20 = 0;
        int n21 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        Attribute attribute = null;
        int n22 = this.readUnsignedShort(n9);
        n9 += 2;
        while (n22-- > 0) {
            String string = this.readUTF8(n9, cArray);
            n7 = this.readInt(n9 + 2);
            n9 += 6;
            if ("LocalVariableTable".equals(string)) {
                if ((context.parsingOptions & 2) == 0) {
                    n20 = n9;
                    int n23 = n9;
                    n6 = this.readUnsignedShort(n23);
                    n23 += 2;
                    while (n6-- > 0) {
                        n5 = this.readUnsignedShort(n23);
                        this.createDebugLabel(n5, labelArray);
                        n4 = this.readUnsignedShort(n23 + 2);
                        this.createDebugLabel(n5 + n4, labelArray);
                        n23 += 10;
                    }
                }
            } else if ("LocalVariableTypeTable".equals(string)) {
                n21 = n9;
            } else if ("LineNumberTable".equals(string)) {
                if ((context.parsingOptions & 2) == 0) {
                    int n24 = n9;
                    n6 = this.readUnsignedShort(n24);
                    n24 += 2;
                    while (n6-- > 0) {
                        n5 = this.readUnsignedShort(n24);
                        n4 = this.readUnsignedShort(n24 + 2);
                        n24 += 4;
                        this.createDebugLabel(n5, labelArray);
                        labelArray[n5].addLineNumber(n4);
                    }
                }
            } else if ("RuntimeVisibleTypeAnnotations".equals(string)) {
                nArray = this.readTypeAnnotations(methodVisitor, context, n9, true);
            } else if ("RuntimeInvisibleTypeAnnotations".equals(string)) {
                nArray2 = this.readTypeAnnotations(methodVisitor, context, n9, false);
            } else if ("StackMapTable".equals(string)) {
                if ((context.parsingOptions & 4) == 0) {
                    n18 = n9 + 2;
                    n19 = n9 + n7;
                }
            } else if ("StackMap".equals(string)) {
                if ((context.parsingOptions & 4) == 0) {
                    n18 = n9 + 2;
                    n19 = n9 + n7;
                    bl2 = false;
                }
            } else {
                Attribute attribute2 = this.readAttribute(context.attributePrototypes, string, n9, n7, cArray, n, labelArray);
                attribute2.nextAttribute = attribute;
                attribute = attribute2;
            }
            n9 += n7;
        }
        boolean bl3 = bl = (context.parsingOptions & 8) != 0;
        if (n18 != 0) {
            context.currentFrameOffset = -1;
            context.currentFrameType = 0;
            context.currentFrameLocalCount = 0;
            context.currentFrameLocalCountDelta = 0;
            context.currentFrameLocalTypes = new Object[n11];
            context.currentFrameStackCount = 0;
            context.currentFrameStackTypes = new Object[n10];
            if (bl) {
                this.computeImplicitFrame(context);
            }
            for (n7 = n18; n7 < n19 - 2; ++n7) {
                int n25;
                if (byArray[n7] != 8 || (n25 = this.readUnsignedShort(n7 + 1)) < 0 || n25 >= n12 || (byArray[n13 + n25] & 0xFF) != 187) continue;
                this.createLabel(n25, labelArray);
            }
        }
        if (bl && (context.parsingOptions & 0x100) != 0) {
            methodVisitor.visitFrame(-1, n11, null, 0, null);
        }
        n7 = 0;
        int n26 = this.getTypeAnnotationBytecodeOffset(nArray, 0);
        n6 = 0;
        n5 = this.getTypeAnnotationBytecodeOffset(nArray2, 0);
        n4 = 0;
        int n27 = (context.parsingOptions & 0x100) == 0 ? 33 : 0;
        n9 = n13;
        while (n9 < n14) {
            int n28 = n9 - n13;
            Label label = labelArray[n28];
            if (label != null) {
                label.accept(methodVisitor, (context.parsingOptions & 2) == 0);
            }
            while (n18 != 0 && (context.currentFrameOffset == n28 || context.currentFrameOffset == -1)) {
                if (context.currentFrameOffset != -1) {
                    if (!bl2 || bl) {
                        methodVisitor.visitFrame(-1, context.currentFrameLocalCount, context.currentFrameLocalTypes, context.currentFrameStackCount, context.currentFrameStackTypes);
                    } else {
                        methodVisitor.visitFrame(context.currentFrameType, context.currentFrameLocalCountDelta, context.currentFrameLocalTypes, context.currentFrameStackCount, context.currentFrameStackTypes);
                    }
                    n4 = 0;
                }
                if (n18 < n19) {
                    n18 = this.readStackMapFrame(n18, bl2, bl, context);
                    continue;
                }
                n18 = 0;
            }
            if (n4 != 0) {
                if ((context.parsingOptions & 8) != 0) {
                    methodVisitor.visitFrame(256, 0, null, 0, null);
                }
                n4 = 0;
            }
            n3 = byArray[n9] & 0xFF;
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    methodVisitor.visitInsn(n3);
                    ++n9;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    methodVisitor.visitVarInsn(21 + ((n3 -= 26) >> 2), n3 & 3);
                    ++n9;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    methodVisitor.visitVarInsn(54 + ((n3 -= 59) >> 2), n3 & 3);
                    ++n9;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    methodVisitor.visitJumpInsn(n3, labelArray[n28 + this.readShort(n9 + 1)]);
                    n9 += 3;
                    break;
                }
                case 200: 
                case 201: {
                    methodVisitor.visitJumpInsn(n3 - n27, labelArray[n28 + this.readInt(n9 + 1)]);
                    n9 += 5;
                    break;
                }
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: {
                    n3 = n3 < 218 ? n3 - 49 : n3 - 20;
                    Label label4 = labelArray[n28 + this.readUnsignedShort(n9 + 1)];
                    if (n3 == 167 || n3 == 168) {
                        methodVisitor.visitJumpInsn(n3 + 33, label4);
                    } else {
                        n3 = n3 < 167 ? (n3 + 1 ^ 1) - 1 : n3 ^ 1;
                        object = this.createLabel(n28 + 3, labelArray);
                        methodVisitor.visitJumpInsn(n3, (Label)object);
                        methodVisitor.visitJumpInsn(200, label4);
                        n4 = 1;
                    }
                    n9 += 3;
                    break;
                }
                case 220: {
                    methodVisitor.visitJumpInsn(200, labelArray[n28 + this.readInt(n9 + 1)]);
                    n4 = 1;
                    n9 += 5;
                    break;
                }
                case 196: {
                    n3 = byArray[n9 + 1] & 0xFF;
                    if (n3 == 132) {
                        methodVisitor.visitIincInsn(this.readUnsignedShort(n9 + 2), this.readShort(n9 + 4));
                        n9 += 6;
                        break;
                    }
                    methodVisitor.visitVarInsn(n3, this.readUnsignedShort(n9 + 2));
                    n9 += 4;
                    break;
                }
                case 170: {
                    Label label5 = labelArray[n28 + this.readInt(n9 += 4 - (n28 & 3))];
                    int n29 = this.readInt(n9 + 4);
                    int n30 = this.readInt(n9 + 8);
                    n9 += 12;
                    Label[] labelArray2 = new Label[n30 - n29 + 1];
                    for (int i = 0; i < labelArray2.length; ++i) {
                        labelArray2[i] = labelArray[n28 + this.readInt(n9)];
                        n9 += 4;
                    }
                    methodVisitor.visitTableSwitchInsn(n29, n30, label5, labelArray2);
                    break;
                }
                case 171: {
                    Label label6 = labelArray[n28 + this.readInt(n9 += 4 - (n28 & 3))];
                    int n31 = this.readInt(n9 + 4);
                    n9 += 8;
                    int[] nArray3 = new int[n31];
                    Label[] labelArray2 = new Label[n31];
                    for (int i = 0; i < n31; ++i) {
                        nArray3[i] = this.readInt(n9);
                        labelArray2[i] = labelArray[n28 + this.readInt(n9 + 4)];
                        n9 += 8;
                    }
                    methodVisitor.visitLookupSwitchInsn(label6, nArray3, labelArray2);
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: {
                    methodVisitor.visitVarInsn(n3, byArray[n9 + 1] & 0xFF);
                    n9 += 2;
                    break;
                }
                case 16: 
                case 188: {
                    methodVisitor.visitIntInsn(n3, byArray[n9 + 1]);
                    n9 += 2;
                    break;
                }
                case 17: {
                    methodVisitor.visitIntInsn(n3, this.readShort(n9 + 1));
                    n9 += 3;
                    break;
                }
                case 18: {
                    methodVisitor.visitLdcInsn(this.readConst(byArray[n9 + 1] & 0xFF, cArray));
                    n9 += 2;
                    break;
                }
                case 19: 
                case 20: {
                    methodVisitor.visitLdcInsn(this.readConst(this.readUnsignedShort(n9 + 1), cArray));
                    n9 += 3;
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    int n32 = this.cpInfoOffsets[this.readUnsignedShort(n9 + 1)];
                    int n33 = this.cpInfoOffsets[this.readUnsignedShort(n32 + 2)];
                    String string = this.readClass(n32, cArray);
                    Label[] labelArray2 = this.readUTF8(n33, cArray);
                    String string2 = this.readUTF8(n33 + 2, cArray);
                    if (n3 < 182) {
                        methodVisitor.visitFieldInsn(n3, string, (String)labelArray2, string2);
                    } else {
                        n2 = byArray[n32 - 1] == 11 ? 1 : 0;
                        methodVisitor.visitMethodInsn(n3, string, (String)labelArray2, string2, n2 != 0);
                    }
                    if (n3 == 185) {
                        n9 += 5;
                        break;
                    }
                    n9 += 3;
                    break;
                }
                case 186: {
                    int n34 = this.cpInfoOffsets[this.readUnsignedShort(n9 + 1)];
                    int n35 = this.cpInfoOffsets[this.readUnsignedShort(n34 + 2)];
                    String string = this.readUTF8(n35, cArray);
                    Label[] labelArray2 = this.readUTF8(n35 + 2, cArray);
                    int n36 = this.bootstrapMethodOffsets[this.readUnsignedShort(n34)];
                    Handle handle = (Handle)this.readConst(this.readUnsignedShort(n36), cArray);
                    Object[] objectArray = new Object[this.readUnsignedShort(n36 + 2)];
                    n36 += 4;
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = this.readConst(this.readUnsignedShort(n36), cArray);
                        n36 += 2;
                    }
                    methodVisitor.visitInvokeDynamicInsn(string, (String)labelArray2, handle, objectArray);
                    n9 += 5;
                    break;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    methodVisitor.visitTypeInsn(n3, this.readClass(n9 + 1, cArray));
                    n9 += 3;
                    break;
                }
                case 132: {
                    methodVisitor.visitIincInsn(byArray[n9 + 1] & 0xFF, byArray[n9 + 2]);
                    n9 += 3;
                    break;
                }
                case 197: {
                    methodVisitor.visitMultiANewArrayInsn(this.readClass(n9 + 1, cArray), byArray[n9 + 3] & 0xFF);
                    n9 += 4;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            while (nArray != null && n7 < nArray.length && n26 <= n28) {
                if (n26 == n28) {
                    int n37 = this.readTypeAnnotationTarget(context, nArray[n7]);
                    object = this.readUTF8(n37, cArray);
                    this.readElementValues(methodVisitor.visitInsnAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, (String)object, true), n37 += 2, true, cArray);
                }
                n26 = this.getTypeAnnotationBytecodeOffset(nArray, ++n7);
            }
            while (nArray2 != null && n6 < nArray2.length && n5 <= n28) {
                if (n5 == n28) {
                    int n38 = this.readTypeAnnotationTarget(context, nArray2[n6]);
                    object = this.readUTF8(n38, cArray);
                    this.readElementValues(methodVisitor.visitInsnAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, (String)object, false), n38 += 2, true, cArray);
                }
                n5 = this.getTypeAnnotationBytecodeOffset(nArray2, ++n6);
            }
        }
        if (labelArray[n12] != null) {
            methodVisitor.visitLabel(labelArray[n12]);
        }
        if (n20 != 0 && (context.parsingOptions & 2) == 0) {
            int[] nArray4 = null;
            if (n21 != 0) {
                nArray4 = new int[this.readUnsignedShort(n21) * 3];
                n9 = n21 + 2;
                int n39 = nArray4.length;
                while (n39 > 0) {
                    nArray4[--n39] = n9 + 6;
                    nArray4[--n39] = this.readUnsignedShort(n9 + 8);
                    nArray4[--n39] = this.readUnsignedShort(n9);
                    n9 += 10;
                }
            }
            int n40 = this.readUnsignedShort(n20);
            n9 = n20 + 2;
            while (n40-- > 0) {
                n3 = this.readUnsignedShort(n9);
                int n41 = this.readUnsignedShort(n9 + 2);
                object = this.readUTF8(n9 + 4, cArray);
                String string = this.readUTF8(n9 + 6, cArray);
                int n42 = this.readUnsignedShort(n9 + 8);
                n9 += 10;
                String string3 = null;
                if (nArray4 != null) {
                    for (n2 = 0; n2 < nArray4.length; n2 += 3) {
                        if (nArray4[n2] != n3 || nArray4[n2 + 1] != n42) continue;
                        string3 = this.readUTF8(nArray4[n2 + 2], cArray);
                        break;
                    }
                }
                methodVisitor.visitLocalVariable((String)object, string, string3, labelArray[n3], labelArray[n3 + n41], n42);
            }
        }
        if (nArray != null) {
            int[] nArray5 = nArray;
            int n43 = nArray5.length;
            for (n3 = 0; n3 < n43; ++n3) {
                int n44 = nArray5[n3];
                int n45 = this.readByte(n44);
                if (n45 != 64 && n45 != 65) continue;
                n9 = this.readTypeAnnotationTarget(context, n44);
                String string = this.readUTF8(n9, cArray);
                this.readElementValues(methodVisitor.visitLocalVariableAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, context.currentLocalVariableAnnotationRangeStarts, context.currentLocalVariableAnnotationRangeEnds, context.currentLocalVariableAnnotationRangeIndices, string, true), n9 += 2, true, cArray);
            }
        }
        if (nArray2 != null) {
            for (int n46 : nArray2) {
                int n47 = this.readByte(n46);
                if (n47 != 64 && n47 != 65) continue;
                n9 = this.readTypeAnnotationTarget(context, n46);
                String string = this.readUTF8(n9, cArray);
                this.readElementValues(methodVisitor.visitLocalVariableAnnotation(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, context.currentLocalVariableAnnotationRangeStarts, context.currentLocalVariableAnnotationRangeEnds, context.currentLocalVariableAnnotationRangeIndices, string, false), n9 += 2, true, cArray);
            }
        }
        while (attribute != null) {
            Attribute attribute3 = attribute.nextAttribute;
            attribute.nextAttribute = null;
            methodVisitor.visitAttribute(attribute);
            attribute = attribute3;
        }
        methodVisitor.visitMaxs(n10, n11);
    }

    protected Label readLabel(int n, Label[] labelArray) {
        if (labelArray[n] == null) {
            labelArray[n] = new Label();
        }
        return labelArray[n];
    }

    private Label createLabel(int n, Label[] labelArray) {
        Label label = this.readLabel(n, labelArray);
        label.flags = (short)(label.flags & 0xFFFFFFFE);
        return label;
    }

    private void createDebugLabel(int n, Label[] labelArray) {
        if (labelArray[n] == null) {
            this.readLabel((int)n, (Label[])labelArray).flags = (short)(this.readLabel((int)n, (Label[])labelArray).flags | 1);
        }
    }

    private int[] readTypeAnnotations(MethodVisitor methodVisitor, Context context, int n, boolean bl) {
        char[] cArray = context.charBuffer;
        int n2 = n;
        int[] nArray = new int[this.readUnsignedShort(n2)];
        n2 += 2;
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            nArray[i] = n2;
            int n4 = this.readInt(n2);
            switch (n4 >>> 24) {
                case 64: 
                case 65: {
                    n3 = this.readUnsignedShort(n2 + 1);
                    n2 += 3;
                    while (n3-- > 0) {
                        int n5 = this.readUnsignedShort(n2);
                        int n6 = this.readUnsignedShort(n2 + 2);
                        n2 += 6;
                        this.createLabel(n5, context.currentMethodLabels);
                        this.createLabel(n5 + n6, context.currentMethodLabels);
                    }
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    n2 += 4;
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 23: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n2 += 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            n3 = this.readByte(n2);
            if (n4 >>> 24 == 66) {
                TypePath typePath = n3 == 0 ? null : new TypePath(this.classFileBuffer, n2);
                String string = this.readUTF8(n2 += 1 + 2 * n3, cArray);
                n2 += 2;
                n2 = this.readElementValues(methodVisitor.visitTryCatchAnnotation(n4 & 0xFFFFFF00, typePath, string, bl), n2, true, cArray);
                continue;
            }
            n2 += 3 + 2 * n3;
            n2 = this.readElementValues(null, n2, true, cArray);
        }
        return nArray;
    }

    private int getTypeAnnotationBytecodeOffset(int[] nArray, int n) {
        if (nArray == null || n >= nArray.length || this.readByte(nArray[n]) < 67) {
            return -1;
        }
        return this.readUnsignedShort(nArray[n] + 1);
    }

    private int readTypeAnnotationTarget(Context context, int n) {
        int n2;
        int n3 = n;
        int n4 = this.readInt(n);
        switch (n4 >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                n4 &= 0xFFFF0000;
                n3 += 2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                n4 &= 0xFF000000;
                ++n3;
                break;
            }
            case 64: 
            case 65: {
                n4 &= 0xFF000000;
                n2 = this.readUnsignedShort(n3 + 1);
                n3 += 3;
                context.currentLocalVariableAnnotationRangeStarts = new Label[n2];
                context.currentLocalVariableAnnotationRangeEnds = new Label[n2];
                context.currentLocalVariableAnnotationRangeIndices = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    int n5 = this.readUnsignedShort(n3);
                    int n6 = this.readUnsignedShort(n3 + 2);
                    int n7 = this.readUnsignedShort(n3 + 4);
                    n3 += 6;
                    context.currentLocalVariableAnnotationRangeStarts[i] = this.createLabel(n5, context.currentMethodLabels);
                    context.currentLocalVariableAnnotationRangeEnds[i] = this.createLabel(n5 + n6, context.currentMethodLabels);
                    context.currentLocalVariableAnnotationRangeIndices[i] = n7;
                }
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                n4 &= 0xFF0000FF;
                n3 += 4;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                n4 &= 0xFFFFFF00;
                n3 += 3;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n4 &= 0xFF000000;
                n3 += 3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        context.currentTypeAnnotationTarget = n4;
        n2 = this.readByte(n3);
        context.currentTypeAnnotationTargetPath = n2 == 0 ? null : new TypePath(this.classFileBuffer, n3);
        return n3 + 1 + 2 * n2;
    }

    private void readParameterAnnotations(MethodVisitor methodVisitor, Context context, int n, boolean bl) {
        int n2 = n;
        int n3 = this.classFileBuffer[n2++] & 0xFF;
        methodVisitor.visitAnnotableParameterCount(n3, bl);
        char[] cArray = context.charBuffer;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.readUnsignedShort(n2);
            n2 += 2;
            while (n4-- > 0) {
                String string = this.readUTF8(n2, cArray);
                n2 += 2;
                n2 = this.readElementValues(methodVisitor.visitParameterAnnotation(i, string, bl), n2, true, cArray);
            }
        }
    }

    private int readElementValues(AnnotationVisitor annotationVisitor, int n, boolean bl, char[] cArray) {
        int n2 = n;
        int n3 = this.readUnsignedShort(n2);
        n2 += 2;
        if (bl) {
            while (n3-- > 0) {
                String string = this.readUTF8(n2, cArray);
                n2 = this.readElementValue(annotationVisitor, n2 + 2, string, cArray);
            }
        } else {
            while (n3-- > 0) {
                n2 = this.readElementValue(annotationVisitor, n2, null, cArray);
            }
        }
        if (annotationVisitor != null) {
            annotationVisitor.visitEnd();
        }
        return n2;
    }

    private int readElementValue(AnnotationVisitor annotationVisitor, int n, String string, char[] cArray) {
        int n2 = n;
        if (annotationVisitor == null) {
            switch (this.classFileBuffer[n2] & 0xFF) {
                case 101: {
                    return n2 + 5;
                }
                case 64: {
                    return this.readElementValues(null, n2 + 3, true, cArray);
                }
                case 91: {
                    return this.readElementValues(null, n2 + 1, false, cArray);
                }
            }
            return n2 + 3;
        }
        block5 : switch (this.classFileBuffer[n2++] & 0xFF) {
            case 66: {
                annotationVisitor.visit(string, (byte)this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2)]));
                n2 += 2;
                break;
            }
            case 67: {
                annotationVisitor.visit(string, Character.valueOf((char)this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2)])));
                n2 += 2;
                break;
            }
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                annotationVisitor.visit(string, this.readConst(this.readUnsignedShort(n2), cArray));
                n2 += 2;
                break;
            }
            case 83: {
                annotationVisitor.visit(string, (short)this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2)]));
                n2 += 2;
                break;
            }
            case 90: {
                annotationVisitor.visit(string, this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                n2 += 2;
                break;
            }
            case 115: {
                annotationVisitor.visit(string, this.readUTF8(n2, cArray));
                n2 += 2;
                break;
            }
            case 101: {
                annotationVisitor.visitEnum(string, this.readUTF8(n2, cArray), this.readUTF8(n2 + 2, cArray));
                n2 += 4;
                break;
            }
            case 99: {
                annotationVisitor.visit(string, Type.getType(this.readUTF8(n2, cArray)));
                n2 += 2;
                break;
            }
            case 64: {
                n2 = this.readElementValues(annotationVisitor.visitAnnotation(string, this.readUTF8(n2, cArray)), n2 + 2, true, cArray);
                break;
            }
            case 91: {
                int n3 = this.readUnsignedShort(n2);
                n2 += 2;
                if (n3 == 0) {
                    return this.readElementValues(annotationVisitor.visitArray(string), n2 - 2, false, cArray);
                }
                switch (this.classFileBuffer[n2] & 0xFF) {
                    case 66: {
                        byte[] byArray = new byte[n3];
                        for (int i = 0; i < n3; ++i) {
                            byArray[i] = (byte)this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, byArray);
                        break block5;
                    }
                    case 90: {
                        boolean[] blArray = new boolean[n3];
                        for (int i = 0; i < n3; ++i) {
                            blArray[i] = this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]) != 0;
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, blArray);
                        break block5;
                    }
                    case 83: {
                        short[] sArray = new short[n3];
                        for (int i = 0; i < n3; ++i) {
                            sArray[i] = (short)this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, sArray);
                        break block5;
                    }
                    case 67: {
                        char[] cArray2 = new char[n3];
                        for (int i = 0; i < n3; ++i) {
                            cArray2[i] = (char)this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, cArray2);
                        break block5;
                    }
                    case 73: {
                        int[] nArray = new int[n3];
                        for (int i = 0; i < n3; ++i) {
                            nArray[i] = this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, nArray);
                        break block5;
                    }
                    case 74: {
                        long[] lArray = new long[n3];
                        for (int i = 0; i < n3; ++i) {
                            lArray[i] = this.readLong(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]);
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, lArray);
                        break block5;
                    }
                    case 70: {
                        float[] fArray = new float[n3];
                        for (int i = 0; i < n3; ++i) {
                            fArray[i] = Float.intBitsToFloat(this.readInt(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]));
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, fArray);
                        break block5;
                    }
                    case 68: {
                        double[] dArray = new double[n3];
                        for (int i = 0; i < n3; ++i) {
                            dArray[i] = Double.longBitsToDouble(this.readLong(this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)]));
                            n2 += 3;
                        }
                        annotationVisitor.visit(string, dArray);
                        break block5;
                    }
                }
                n2 = this.readElementValues(annotationVisitor.visitArray(string), n2 - 2, false, cArray);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n2;
    }

    private void computeImplicitFrame(Context context) {
        String string = context.currentMethodDescriptor;
        Object[] objectArray = context.currentFrameLocalTypes;
        int n = 0;
        if ((context.currentMethodAccessFlags & 8) == 0) {
            objectArray[n++] = "<init>".equals(context.currentMethodName) ? Opcodes.UNINITIALIZED_THIS : this.readClass(this.header + 2, context.charBuffer);
        }
        int n2 = 1;
        block8: while (true) {
            int n3 = n2;
            switch (string.charAt(n2++)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    objectArray[n++] = Opcodes.INTEGER;
                    continue block8;
                }
                case 'F': {
                    objectArray[n++] = Opcodes.FLOAT;
                    continue block8;
                }
                case 'J': {
                    objectArray[n++] = Opcodes.LONG;
                    continue block8;
                }
                case 'D': {
                    objectArray[n++] = Opcodes.DOUBLE;
                    continue block8;
                }
                case '[': {
                    while (string.charAt(n2) == '[') {
                        ++n2;
                    }
                    if (string.charAt(n2) == 'L') {
                        ++n2;
                        while (string.charAt(n2) != ';') {
                            ++n2;
                        }
                    }
                    objectArray[n++] = string.substring(n3, ++n2);
                    continue block8;
                }
                case 'L': {
                    while (string.charAt(n2) != ';') {
                        ++n2;
                    }
                    objectArray[n++] = string.substring(n3 + 1, n2++);
                    continue block8;
                }
            }
            break;
        }
        context.currentFrameLocalCount = n;
    }

    private int readStackMapFrame(int n, boolean bl, boolean bl2, Context context) {
        int n2;
        int n3;
        int n4 = n;
        char[] cArray = context.charBuffer;
        Label[] labelArray = context.currentMethodLabels;
        if (bl) {
            n3 = this.classFileBuffer[n4++] & 0xFF;
        } else {
            n3 = 255;
            context.currentFrameOffset = -1;
        }
        context.currentFrameLocalCountDelta = 0;
        if (n3 < 64) {
            n2 = n3;
            context.currentFrameType = 3;
            context.currentFrameStackCount = 0;
        } else if (n3 < 128) {
            n2 = n3 - 64;
            n4 = this.readVerificationTypeInfo(n4, context.currentFrameStackTypes, 0, cArray, labelArray);
            context.currentFrameType = 4;
            context.currentFrameStackCount = 1;
        } else if (n3 >= 247) {
            n2 = this.readUnsignedShort(n4);
            n4 += 2;
            if (n3 == 247) {
                n4 = this.readVerificationTypeInfo(n4, context.currentFrameStackTypes, 0, cArray, labelArray);
                context.currentFrameType = 4;
                context.currentFrameStackCount = 1;
            } else if (n3 >= 248 && n3 < 251) {
                context.currentFrameType = 2;
                context.currentFrameLocalCountDelta = 251 - n3;
                context.currentFrameLocalCount -= context.currentFrameLocalCountDelta;
                context.currentFrameStackCount = 0;
            } else if (n3 == 251) {
                context.currentFrameType = 3;
                context.currentFrameStackCount = 0;
            } else if (n3 < 255) {
                int n5 = bl2 ? context.currentFrameLocalCount : 0;
                for (int i = n3 - 251; i > 0; --i) {
                    n4 = this.readVerificationTypeInfo(n4, context.currentFrameLocalTypes, n5++, cArray, labelArray);
                }
                context.currentFrameType = 1;
                context.currentFrameLocalCountDelta = n3 - 251;
                context.currentFrameLocalCount += context.currentFrameLocalCountDelta;
                context.currentFrameStackCount = 0;
            } else {
                int n6;
                int n7 = this.readUnsignedShort(n4);
                n4 += 2;
                context.currentFrameType = 0;
                context.currentFrameLocalCountDelta = n7;
                context.currentFrameLocalCount = n7;
                for (n6 = 0; n6 < n7; ++n6) {
                    n4 = this.readVerificationTypeInfo(n4, context.currentFrameLocalTypes, n6, cArray, labelArray);
                }
                n6 = this.readUnsignedShort(n4);
                n4 += 2;
                context.currentFrameStackCount = n6;
                for (int i = 0; i < n6; ++i) {
                    n4 = this.readVerificationTypeInfo(n4, context.currentFrameStackTypes, i, cArray, labelArray);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        context.currentFrameOffset += n2 + 1;
        this.createLabel(context.currentFrameOffset, labelArray);
        return n4;
    }

    private int readVerificationTypeInfo(int n, Object[] objectArray, int n2, char[] cArray, Label[] labelArray) {
        int n3 = n;
        int n4 = this.classFileBuffer[n3++] & 0xFF;
        switch (n4) {
            case 0: {
                objectArray[n2] = Opcodes.TOP;
                break;
            }
            case 1: {
                objectArray[n2] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                objectArray[n2] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                objectArray[n2] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                objectArray[n2] = Opcodes.LONG;
                break;
            }
            case 5: {
                objectArray[n2] = Opcodes.NULL;
                break;
            }
            case 6: {
                objectArray[n2] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                objectArray[n2] = this.readClass(n3, cArray);
                n3 += 2;
                break;
            }
            case 8: {
                objectArray[n2] = this.createLabel(this.readUnsignedShort(n3), labelArray);
                n3 += 2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n3;
    }

    final int getFirstAttributeOffset() {
        int n;
        int n2 = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        int n3 = this.readUnsignedShort(n2);
        n2 += 2;
        while (n3-- > 0) {
            n = this.readUnsignedShort(n2 + 6);
            n2 += 8;
            while (n-- > 0) {
                n2 += 6 + this.readInt(n2 + 2);
            }
        }
        n = this.readUnsignedShort(n2);
        n2 += 2;
        while (n-- > 0) {
            int n4 = this.readUnsignedShort(n2 + 6);
            n2 += 8;
            while (n4-- > 0) {
                n2 += 6 + this.readInt(n2 + 2);
            }
        }
        return n2 + 2;
    }

    private int[] readBootstrapMethodsAttribute(int n) {
        char[] cArray = new char[n];
        int n2 = this.getFirstAttributeOffset();
        for (int i = this.readUnsignedShort(n2 - 2); i > 0; --i) {
            String string = this.readUTF8(n2, cArray);
            int n3 = this.readInt(n2 + 2);
            n2 += 6;
            if ("BootstrapMethods".equals(string)) {
                int[] nArray = new int[this.readUnsignedShort(n2)];
                int n4 = n2 + 2;
                for (int j = 0; j < nArray.length; ++j) {
                    nArray[j] = n4;
                    n4 += 4 + this.readUnsignedShort(n4 + 2) * 2;
                }
                return nArray;
            }
            n2 += n3;
        }
        throw new IllegalArgumentException();
    }

    private Attribute readAttribute(Attribute[] attributeArray, String string, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        for (Attribute attribute : attributeArray) {
            if (!attribute.type.equals(string)) continue;
            return attribute.read(this, n, n2, cArray, n3, labelArray);
        }
        return new Attribute(string).read(this, n, n2, null, -1, null);
    }

    public int getItemCount() {
        return this.cpInfoOffsets.length;
    }

    public int getItem(int n) {
        return this.cpInfoOffsets[n];
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int readByte(int n) {
        return this.classFileBuffer[n] & 0xFF;
    }

    public int readUnsignedShort(int n) {
        byte[] byArray = this.classFileBuffer;
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public short readShort(int n) {
        byte[] byArray = this.classFileBuffer;
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public int readInt(int n) {
        byte[] byArray = this.classFileBuffer;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public long readLong(int n) {
        long l = this.readInt(n);
        long l2 = (long)this.readInt(n + 4) & 0xFFFFFFFFL;
        return l << 32 | l2;
    }

    public String readUTF8(int n, char[] cArray) {
        int n2 = this.readUnsignedShort(n);
        if (n == 0 || n2 == 0) {
            return null;
        }
        return this.readUtf(n2, cArray);
    }

    final String readUtf(int n, char[] cArray) {
        String string = this.constantUtf8Values[n];
        if (string != null) {
            return string;
        }
        int n2 = this.cpInfoOffsets[n];
        this.constantUtf8Values[n] = this.readUtf(n2 + 2, this.readUnsignedShort(n2), cArray);
        return this.constantUtf8Values[n];
    }

    private String readUtf(int n, int n2, char[] cArray) {
        int n3 = n;
        int n4 = n3 + n2;
        int n5 = 0;
        byte[] byArray = this.classFileBuffer;
        while (n3 < n4) {
            byte by;
            if (((by = byArray[n3++]) & 0x80) == 0) {
                cArray[n5++] = (char)(by & 0x7F);
                continue;
            }
            if ((by & 0xE0) == 192) {
                cArray[n5++] = (char)(((by & 0x1F) << 6) + (byArray[n3++] & 0x3F));
                continue;
            }
            cArray[n5++] = (char)(((by & 0xF) << 12) + ((byArray[n3++] & 0x3F) << 6) + (byArray[n3++] & 0x3F));
        }
        return new String(cArray, 0, n5);
    }

    private String readStringish(int n, char[] cArray) {
        return this.readUTF8(this.cpInfoOffsets[this.readUnsignedShort(n)], cArray);
    }

    public String readClass(int n, char[] cArray) {
        return this.readStringish(n, cArray);
    }

    public String readModule(int n, char[] cArray) {
        return this.readStringish(n, cArray);
    }

    public String readPackage(int n, char[] cArray) {
        return this.readStringish(n, cArray);
    }

    private ConstantDynamic readConstantDynamic(int n, char[] cArray) {
        ConstantDynamic constantDynamic = this.constantDynamicValues[n];
        if (constantDynamic != null) {
            return constantDynamic;
        }
        int n2 = this.cpInfoOffsets[n];
        int n3 = this.cpInfoOffsets[this.readUnsignedShort(n2 + 2)];
        String string = this.readUTF8(n3, cArray);
        String string2 = this.readUTF8(n3 + 2, cArray);
        int n4 = this.bootstrapMethodOffsets[this.readUnsignedShort(n2)];
        Handle handle = (Handle)this.readConst(this.readUnsignedShort(n4), cArray);
        Object[] objectArray = new Object[this.readUnsignedShort(n4 + 2)];
        n4 += 4;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.readConst(this.readUnsignedShort(n4), cArray);
            n4 += 2;
        }
        this.constantDynamicValues[n] = new ConstantDynamic(string, string2, handle, objectArray);
        return this.constantDynamicValues[n];
    }

    public Object readConst(int n, char[] cArray) {
        int n2 = this.cpInfoOffsets[n];
        switch (this.classFileBuffer[n2 - 1]) {
            case 3: {
                return this.readInt(n2);
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.readInt(n2)));
            }
            case 5: {
                return this.readLong(n2);
            }
            case 6: {
                return Double.longBitsToDouble(this.readLong(n2));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(n2, cArray));
            }
            case 8: {
                return this.readUTF8(n2, cArray);
            }
            case 16: {
                return Type.getMethodType(this.readUTF8(n2, cArray));
            }
            case 15: {
                int n3 = this.readByte(n2);
                int n4 = this.cpInfoOffsets[this.readUnsignedShort(n2 + 1)];
                int n5 = this.cpInfoOffsets[this.readUnsignedShort(n4 + 2)];
                String string = this.readClass(n4, cArray);
                String string2 = this.readUTF8(n5, cArray);
                String string3 = this.readUTF8(n5 + 2, cArray);
                boolean bl = this.classFileBuffer[n4 - 1] == 11;
                return new Handle(n3, string, string2, string3, bl);
            }
            case 17: {
                return this.readConstantDynamic(n, cArray);
            }
        }
        throw new IllegalArgumentException();
    }
}

