/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm;

import pro.gravit.repackage.org.objectweb.asm.ByteVector;
import pro.gravit.repackage.org.objectweb.asm.Label;
import pro.gravit.repackage.org.objectweb.asm.MethodWriter;
import pro.gravit.repackage.org.objectweb.asm.Opcodes;
import pro.gravit.repackage.org.objectweb.asm.Symbol;
import pro.gravit.repackage.org.objectweb.asm.SymbolTable;
import pro.gravit.repackage.org.objectweb.asm.Type;

class Frame {
    static final int SAME_FRAME = 0;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME = 64;
    static final int RESERVED = 128;
    static final int SAME_LOCALS_1_STACK_ITEM_FRAME_EXTENDED = 247;
    static final int CHOP_FRAME = 248;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int APPEND_FRAME = 252;
    static final int FULL_FRAME = 255;
    static final int ITEM_TOP = 0;
    static final int ITEM_INTEGER = 1;
    static final int ITEM_FLOAT = 2;
    static final int ITEM_DOUBLE = 3;
    static final int ITEM_LONG = 4;
    static final int ITEM_NULL = 5;
    static final int ITEM_UNINITIALIZED_THIS = 6;
    static final int ITEM_OBJECT = 7;
    static final int ITEM_UNINITIALIZED = 8;
    private static final int ITEM_ASM_BOOLEAN = 9;
    private static final int ITEM_ASM_BYTE = 10;
    private static final int ITEM_ASM_CHAR = 11;
    private static final int ITEM_ASM_SHORT = 12;
    private static final int DIM_SIZE = 6;
    private static final int KIND_SIZE = 4;
    private static final int FLAGS_SIZE = 2;
    private static final int VALUE_SIZE = 20;
    private static final int DIM_SHIFT = 26;
    private static final int KIND_SHIFT = 22;
    private static final int FLAGS_SHIFT = 20;
    private static final int DIM_MASK = -67108864;
    private static final int KIND_MASK = 0x3C00000;
    private static final int VALUE_MASK = 1048575;
    private static final int ARRAY_OF = 0x4000000;
    private static final int ELEMENT_OF = -67108864;
    private static final int CONSTANT_KIND = 0x400000;
    private static final int REFERENCE_KIND = 0x800000;
    private static final int UNINITIALIZED_KIND = 0xC00000;
    private static final int LOCAL_KIND = 0x1000000;
    private static final int STACK_KIND = 0x1400000;
    private static final int TOP_IF_LONG_OR_DOUBLE_FLAG = 0x100000;
    private static final int TOP = 0x400000;
    private static final int BOOLEAN = 0x400009;
    private static final int BYTE = 0x40000A;
    private static final int CHAR = 0x40000B;
    private static final int SHORT = 0x40000C;
    private static final int INTEGER = 0x400001;
    private static final int FLOAT = 0x400002;
    private static final int LONG = 0x400004;
    private static final int DOUBLE = 0x400003;
    private static final int NULL = 0x400005;
    private static final int UNINITIALIZED_THIS = 0x400006;
    Label owner;
    private int[] inputLocals;
    private int[] inputStack;
    private int[] outputLocals;
    private int[] outputStack;
    private short outputStackStart;
    private short outputStackTop;
    private int initializationCount;
    private int[] initializations;

    Frame(Label label) {
        this.owner = label;
    }

    final void copyFrom(Frame frame) {
        this.inputLocals = frame.inputLocals;
        this.inputStack = frame.inputStack;
        this.outputStackStart = 0;
        this.outputLocals = frame.outputLocals;
        this.outputStack = frame.outputStack;
        this.outputStackTop = frame.outputStackTop;
        this.initializationCount = frame.initializationCount;
        this.initializations = frame.initializations;
    }

    static int getAbstractTypeFromApiFormat(SymbolTable symbolTable, Object object) {
        if (object instanceof Integer) {
            return 0x400000 | (Integer)object;
        }
        if (object instanceof String) {
            String string = Type.getObjectType((String)object).getDescriptor();
            return Frame.getAbstractTypeFromDescriptor(symbolTable, string, 0);
        }
        return 0xC00000 | symbolTable.addUninitializedType("", ((Label)object).bytecodeOffset);
    }

    static int getAbstractTypeFromInternalName(SymbolTable symbolTable, String string) {
        return 0x800000 | symbolTable.addType(string);
    }

    private static int getAbstractTypeFromDescriptor(SymbolTable symbolTable, String string, int n) {
        switch (string.charAt(n)) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0x400001;
            }
            case 'F': {
                return 0x400002;
            }
            case 'J': {
                return 0x400004;
            }
            case 'D': {
                return 0x400003;
            }
            case 'L': {
                String string2 = string.substring(n + 1, string.length() - 1);
                return 0x800000 | symbolTable.addType(string2);
            }
            case '[': {
                int n2;
                int n3 = n + 1;
                while (string.charAt(n3) == '[') {
                    ++n3;
                }
                switch (string.charAt(n3)) {
                    case 'Z': {
                        n2 = 0x400009;
                        break;
                    }
                    case 'C': {
                        n2 = 0x40000B;
                        break;
                    }
                    case 'B': {
                        n2 = 0x40000A;
                        break;
                    }
                    case 'S': {
                        n2 = 0x40000C;
                        break;
                    }
                    case 'I': {
                        n2 = 0x400001;
                        break;
                    }
                    case 'F': {
                        n2 = 0x400002;
                        break;
                    }
                    case 'J': {
                        n2 = 0x400004;
                        break;
                    }
                    case 'D': {
                        n2 = 0x400003;
                        break;
                    }
                    case 'L': {
                        String string3 = string.substring(n3 + 1, string.length() - 1);
                        n2 = 0x800000 | symbolTable.addType(string3);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                return n3 - n << 26 | n2;
            }
        }
        throw new IllegalArgumentException();
    }

    final void setInputFrameFromDescriptor(SymbolTable symbolTable, int n, String string, int n2) {
        this.inputLocals = new int[n2];
        this.inputStack = new int[0];
        int n3 = 0;
        if ((n & 8) == 0) {
            this.inputLocals[n3++] = (n & 0x40000) == 0 ? 0x800000 | symbolTable.addType(symbolTable.getClassName()) : 0x400006;
        }
        for (Type type : Type.getArgumentTypes(string)) {
            int n4 = Frame.getAbstractTypeFromDescriptor(symbolTable, type.getDescriptor(), 0);
            this.inputLocals[n3++] = n4;
            if (n4 != 0x400004 && n4 != 0x400003) continue;
            this.inputLocals[n3++] = 0x400000;
        }
        while (n3 < n2) {
            this.inputLocals[n3++] = 0x400000;
        }
    }

    final void setInputFrameFromApiFormat(SymbolTable symbolTable, int n, Object[] objectArray, int n2, Object[] objectArray2) {
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < n; ++n4) {
            this.inputLocals[n5++] = Frame.getAbstractTypeFromApiFormat(symbolTable, objectArray[n4]);
            if (objectArray[n4] != Opcodes.LONG && objectArray[n4] != Opcodes.DOUBLE) continue;
            this.inputLocals[n5++] = 0x400000;
        }
        while (n5 < this.inputLocals.length) {
            this.inputLocals[n5++] = 0x400000;
        }
        n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            if (objectArray2[n3] != Opcodes.LONG && objectArray2[n3] != Opcodes.DOUBLE) continue;
            ++n4;
        }
        this.inputStack = new int[n2 + n4];
        n3 = 0;
        for (int i = 0; i < n2; ++i) {
            this.inputStack[n3++] = Frame.getAbstractTypeFromApiFormat(symbolTable, objectArray2[i]);
            if (objectArray2[i] != Opcodes.LONG && objectArray2[i] != Opcodes.DOUBLE) continue;
            this.inputStack[n3++] = 0x400000;
        }
        this.outputStackTop = 0;
        this.initializationCount = 0;
    }

    final int getInputStackSize() {
        return this.inputStack.length;
    }

    private int getLocal(int n) {
        if (this.outputLocals == null || n >= this.outputLocals.length) {
            return 0x1000000 | n;
        }
        int n2 = this.outputLocals[n];
        if (n2 == 0) {
            n2 = this.outputLocals[n] = 0x1000000 | n;
        }
        return n2;
    }

    private void setLocal(int n, int n2) {
        int n3;
        if (this.outputLocals == null) {
            this.outputLocals = new int[10];
        }
        if (n >= (n3 = this.outputLocals.length)) {
            int[] nArray = new int[Math.max(n + 1, 2 * n3)];
            System.arraycopy(this.outputLocals, 0, nArray, 0, n3);
            this.outputLocals = nArray;
        }
        this.outputLocals[n] = n2;
    }

    private void push(int n) {
        int n2;
        if (this.outputStack == null) {
            this.outputStack = new int[10];
        }
        if (this.outputStackTop >= (n2 = this.outputStack.length)) {
            int[] nArray = new int[Math.max(this.outputStackTop + 1, 2 * n2)];
            System.arraycopy(this.outputStack, 0, nArray, 0, n2);
            this.outputStack = nArray;
        }
        short s = this.outputStackTop;
        this.outputStackTop = (short)(s + 1);
        this.outputStack[s] = n;
        short s2 = (short)(this.outputStackStart + this.outputStackTop);
        if (s2 > this.owner.outputStackMax) {
            this.owner.outputStackMax = s2;
        }
    }

    private void push(SymbolTable symbolTable, String string) {
        int n = string.charAt(0) == '(' ? Type.getReturnTypeOffset(string) : 0;
        int n2 = Frame.getAbstractTypeFromDescriptor(symbolTable, string, n);
        if (n2 != 0) {
            this.push(n2);
            if (n2 == 0x400004 || n2 == 0x400003) {
                this.push(0x400000);
            }
        }
    }

    private int pop() {
        if (this.outputStackTop > 0) {
            this.outputStackTop = (short)(this.outputStackTop - 1);
            return this.outputStack[this.outputStackTop];
        }
        this.outputStackStart = (short)(this.outputStackStart - 1);
        return 0x1400000 | -this.outputStackStart;
    }

    private void pop(int n) {
        if (this.outputStackTop >= n) {
            this.outputStackTop = (short)(this.outputStackTop - n);
        } else {
            this.outputStackStart = (short)(this.outputStackStart - (n - this.outputStackTop));
            this.outputStackTop = 0;
        }
    }

    private void pop(String string) {
        char c = string.charAt(0);
        if (c == '(') {
            this.pop((Type.getArgumentsAndReturnSizes(string) >> 2) - 1);
        } else if (c == 'J' || c == 'D') {
            this.pop(2);
        } else {
            this.pop(1);
        }
    }

    private void addInitializedType(int n) {
        int n2;
        if (this.initializations == null) {
            this.initializations = new int[2];
        }
        if (this.initializationCount >= (n2 = this.initializations.length)) {
            int[] nArray = new int[Math.max(this.initializationCount + 1, 2 * n2)];
            System.arraycopy(this.initializations, 0, nArray, 0, n2);
            this.initializations = nArray;
        }
        this.initializations[this.initializationCount++] = n;
    }

    private int getInitializedType(SymbolTable symbolTable, int n) {
        if (n == 0x400006 || (n & 0xFFC00000) == 0xC00000) {
            for (int i = 0; i < this.initializationCount; ++i) {
                int n2 = this.initializations[i];
                int n3 = n2 & 0xFC000000;
                int n4 = n2 & 0x3C00000;
                int n5 = n2 & 0xFFFFF;
                if (n4 == 0x1000000) {
                    n2 = n3 + this.inputLocals[n5];
                } else if (n4 == 0x1400000) {
                    n2 = n3 + this.inputStack[this.inputStack.length - n5];
                }
                if (n != n2) continue;
                if (n == 0x400006) {
                    return 0x800000 | symbolTable.addType(symbolTable.getClassName());
                }
                return 0x800000 | symbolTable.addType(symbolTable.getType((int)(n & 0xFFFFF)).value);
            }
        }
        return n;
    }

    void execute(int n, int n2, Symbol symbol, SymbolTable symbolTable) {
        block0 : switch (n) {
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 145: 
            case 146: 
            case 147: 
            case 167: 
            case 177: {
                break;
            }
            case 1: {
                this.push(0x400005);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: {
                this.push(0x400001);
                break;
            }
            case 9: 
            case 10: 
            case 22: {
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 23: {
                this.push(0x400002);
                break;
            }
            case 14: 
            case 15: 
            case 24: {
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 18: {
                switch (symbol.tag) {
                    case 3: {
                        this.push(0x400001);
                        break block0;
                    }
                    case 5: {
                        this.push(0x400004);
                        this.push(0x400000);
                        break block0;
                    }
                    case 4: {
                        this.push(0x400002);
                        break block0;
                    }
                    case 6: {
                        this.push(0x400003);
                        this.push(0x400000);
                        break block0;
                    }
                    case 7: {
                        this.push(0x800000 | symbolTable.addType("java/lang/Class"));
                        break block0;
                    }
                    case 8: {
                        this.push(0x800000 | symbolTable.addType("java/lang/String"));
                        break block0;
                    }
                    case 16: {
                        this.push(0x800000 | symbolTable.addType("java/lang/invoke/MethodType"));
                        break block0;
                    }
                    case 15: {
                        this.push(0x800000 | symbolTable.addType("java/lang/invoke/MethodHandle"));
                        break block0;
                    }
                    case 17: {
                        this.push(symbolTable, symbol.value);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case 25: {
                this.push(this.getLocal(n2));
                break;
            }
            case 47: 
            case 143: {
                this.pop(2);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 49: 
            case 138: {
                this.pop(2);
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 50: {
                this.pop(1);
                int n3 = this.pop();
                this.push(n3 == 0x400005 ? n3 : -67108864 + n3);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                int n4 = this.pop();
                this.setLocal(n2, n4);
                if (n2 <= 0) break;
                int n5 = this.getLocal(n2 - 1);
                if (n5 == 0x400004 || n5 == 0x400003) {
                    this.setLocal(n2 - 1, 0x400000);
                    break;
                }
                if ((n5 & 0x3C00000) != 0x1000000 && (n5 & 0x3C00000) != 0x1400000) break;
                this.setLocal(n2 - 1, n5 | 0x100000);
                break;
            }
            case 55: 
            case 57: {
                this.pop(1);
                int n6 = this.pop();
                this.setLocal(n2, n6);
                this.setLocal(n2 + 1, 0x400000);
                if (n2 <= 0) break;
                int n7 = this.getLocal(n2 - 1);
                if (n7 == 0x400004 || n7 == 0x400003) {
                    this.setLocal(n2 - 1, 0x400000);
                    break;
                }
                if ((n7 & 0x3C00000) != 0x1000000 && (n7 & 0x3C00000) != 0x1400000) break;
                this.setLocal(n2 - 1, n7 | 0x100000);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.pop(4);
                break;
            }
            case 87: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                this.pop(1);
                break;
            }
            case 88: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                this.pop(2);
                break;
            }
            case 89: {
                int n8 = this.pop();
                this.push(n8);
                this.push(n8);
                break;
            }
            case 90: {
                int n9 = this.pop();
                int n10 = this.pop();
                this.push(n9);
                this.push(n10);
                this.push(n9);
                break;
            }
            case 91: {
                int n11 = this.pop();
                int n12 = this.pop();
                int n13 = this.pop();
                this.push(n11);
                this.push(n13);
                this.push(n12);
                this.push(n11);
                break;
            }
            case 92: {
                int n14 = this.pop();
                int n15 = this.pop();
                this.push(n15);
                this.push(n14);
                this.push(n15);
                this.push(n14);
                break;
            }
            case 93: {
                int n16 = this.pop();
                int n17 = this.pop();
                int n18 = this.pop();
                this.push(n17);
                this.push(n16);
                this.push(n18);
                this.push(n17);
                this.push(n16);
                break;
            }
            case 94: {
                int n19 = this.pop();
                int n20 = this.pop();
                int n21 = this.pop();
                int n22 = this.pop();
                this.push(n20);
                this.push(n19);
                this.push(n22);
                this.push(n21);
                this.push(n20);
                this.push(n19);
                break;
            }
            case 95: {
                int n23 = this.pop();
                int n24 = this.pop();
                this.push(n23);
                this.push(n24);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 142: 
            case 149: 
            case 150: {
                this.pop(2);
                this.push(0x400001);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.pop(4);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 137: 
            case 144: {
                this.pop(2);
                this.push(0x400002);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.pop(4);
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop(3);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 132: {
                this.setLocal(n2, 0x400001);
                break;
            }
            case 133: 
            case 140: {
                this.pop(1);
                this.push(0x400004);
                this.push(0x400000);
                break;
            }
            case 134: {
                this.pop(1);
                this.push(0x400002);
                break;
            }
            case 135: 
            case 141: {
                this.pop(1);
                this.push(0x400003);
                this.push(0x400000);
                break;
            }
            case 139: 
            case 190: 
            case 193: {
                this.pop(1);
                this.push(0x400001);
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop(4);
                this.push(0x400001);
                break;
            }
            case 168: 
            case 169: {
                throw new IllegalArgumentException("JSR/RET are not supported with computeFrames option");
            }
            case 178: {
                this.push(symbolTable, symbol.value);
                break;
            }
            case 179: {
                this.pop(symbol.value);
                break;
            }
            case 180: {
                this.pop(1);
                this.push(symbolTable, symbol.value);
                break;
            }
            case 181: {
                this.pop(symbol.value);
                this.pop();
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.pop(symbol.value);
                if (n != 184) {
                    int n25 = this.pop();
                    if (n == 183 && symbol.name.charAt(0) == '<') {
                        this.addInitializedType(n25);
                    }
                }
                this.push(symbolTable, symbol.value);
                break;
            }
            case 186: {
                this.pop(symbol.value);
                this.push(symbolTable, symbol.value);
                break;
            }
            case 187: {
                this.push(0xC00000 | symbolTable.addUninitializedType(symbol.value, n2));
                break;
            }
            case 188: {
                this.pop();
                switch (n2) {
                    case 4: {
                        this.push(0x4400009);
                        break block0;
                    }
                    case 5: {
                        this.push(0x440000B);
                        break block0;
                    }
                    case 8: {
                        this.push(0x440000A);
                        break block0;
                    }
                    case 9: {
                        this.push(0x440000C);
                        break block0;
                    }
                    case 10: {
                        this.push(0x4400001);
                        break block0;
                    }
                    case 6: {
                        this.push(0x4400002);
                        break block0;
                    }
                    case 7: {
                        this.push(0x4400003);
                        break block0;
                    }
                    case 11: {
                        this.push(0x4400004);
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 189: {
                String string = symbol.value;
                this.pop();
                if (string.charAt(0) == '[') {
                    this.push(symbolTable, '[' + string);
                    break;
                }
                this.push(0x4800000 | symbolTable.addType(string));
                break;
            }
            case 192: {
                String string = symbol.value;
                this.pop();
                if (string.charAt(0) == '[') {
                    this.push(symbolTable, string);
                    break;
                }
                this.push(0x800000 | symbolTable.addType(string));
                break;
            }
            case 197: {
                this.pop(n2);
                this.push(symbolTable, symbol.value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private int getConcreteOutputType(int n, int n2) {
        int n3 = n & 0xFC000000;
        int n4 = n & 0x3C00000;
        if (n4 == 0x1000000) {
            int n5 = n3 + this.inputLocals[n & 0xFFFFF];
            if ((n & 0x100000) != 0 && (n5 == 0x400004 || n5 == 0x400003)) {
                n5 = 0x400000;
            }
            return n5;
        }
        if (n4 == 0x1400000) {
            int n6 = n3 + this.inputStack[n2 - (n & 0xFFFFF)];
            if ((n & 0x100000) != 0 && (n6 == 0x400004 || n6 == 0x400003)) {
                n6 = 0x400000;
            }
            return n6;
        }
        return n;
    }

    final boolean merge(SymbolTable symbolTable, Frame frame, int n) {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = this.inputLocals.length;
        int n6 = this.inputStack.length;
        if (frame.inputLocals == null) {
            frame.inputLocals = new int[n5];
            bl = true;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n2 = this.outputLocals != null && n4 < this.outputLocals.length ? ((n3 = this.outputLocals[n4]) == 0 ? this.inputLocals[n4] : this.getConcreteOutputType(n3, n6)) : this.inputLocals[n4];
            if (this.initializations != null) {
                n2 = this.getInitializedType(symbolTable, n2);
            }
            bl |= Frame.merge(symbolTable, n2, frame.inputLocals, n4);
        }
        if (n > 0) {
            for (n4 = 0; n4 < n5; ++n4) {
                bl |= Frame.merge(symbolTable, this.inputLocals[n4], frame.inputLocals, n4);
            }
            if (frame.inputStack == null) {
                frame.inputStack = new int[1];
                bl = true;
            }
            return bl |= Frame.merge(symbolTable, n, frame.inputStack, 0);
        }
        n4 = this.inputStack.length + this.outputStackStart;
        if (frame.inputStack == null) {
            frame.inputStack = new int[n4 + this.outputStackTop];
            bl = true;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            n3 = this.inputStack[n2];
            if (this.initializations != null) {
                n3 = this.getInitializedType(symbolTable, n3);
            }
            bl |= Frame.merge(symbolTable, n3, frame.inputStack, n2);
        }
        for (n2 = 0; n2 < this.outputStackTop; ++n2) {
            n3 = this.outputStack[n2];
            int n7 = this.getConcreteOutputType(n3, n6);
            if (this.initializations != null) {
                n7 = this.getInitializedType(symbolTable, n7);
            }
            bl |= Frame.merge(symbolTable, n7, frame.inputStack, n4 + n2);
        }
        return bl;
    }

    private static boolean merge(SymbolTable symbolTable, int n, int[] nArray, int n2) {
        int n3;
        int n4 = nArray[n2];
        if (n4 == n) {
            return false;
        }
        int n5 = n;
        if ((n & 0x3FFFFFF) == 0x400005) {
            if (n4 == 0x400005) {
                return false;
            }
            n5 = 0x400005;
        }
        if (n4 == 0) {
            nArray[n2] = n5;
            return true;
        }
        if ((n4 & 0xFC000000) != 0 || (n4 & 0x3C00000) == 0x800000) {
            if (n5 == 0x400005) {
                return false;
            }
            if ((n5 & 0xFFC00000) == (n4 & 0xFFC00000)) {
                if ((n4 & 0x3C00000) == 0x800000) {
                    n3 = n5 & 0xFC000000 | 0x800000 | symbolTable.addMergedType(n5 & 0xFFFFF, n4 & 0xFFFFF);
                } else {
                    int n6 = -67108864 + (n5 & 0xFC000000);
                    n3 = n6 | 0x800000 | symbolTable.addType("java/lang/Object");
                }
            } else if ((n5 & 0xFC000000) != 0 || (n5 & 0x3C00000) == 0x800000) {
                int n7;
                int n8 = n5 & 0xFC000000;
                if (n8 != 0 && (n5 & 0x3C00000) != 0x800000) {
                    n8 = -67108864 + n8;
                }
                if ((n7 = n4 & 0xFC000000) != 0 && (n4 & 0x3C00000) != 0x800000) {
                    n7 = -67108864 + n7;
                }
                n3 = Math.min(n8, n7) | 0x800000 | symbolTable.addType("java/lang/Object");
            } else {
                n3 = 0x400000;
            }
        } else {
            n3 = n4 == 0x400005 ? ((n5 & 0xFC000000) != 0 || (n5 & 0x3C00000) == 0x800000 ? n5 : 0x400000) : 0x400000;
        }
        if (n3 != n4) {
            nArray[n2] = n3;
            return true;
        }
        return false;
    }

    final void accept(MethodWriter methodWriter) {
        int n;
        int n2;
        int[] nArray = this.inputLocals;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6;
            n5 += (n6 = nArray[n5]) == 0x400004 || n6 == 0x400003 ? 2 : 1;
            if (n6 == 0x400000) {
                ++n4;
                continue;
            }
            n3 += n4 + 1;
            n4 = 0;
        }
        int[] nArray2 = this.inputStack;
        int n7 = 0;
        n5 = 0;
        while (n5 < nArray2.length) {
            n5 += (n2 = nArray2[n5]) == 0x400004 || n2 == 0x400003 ? 2 : 1;
            ++n7;
        }
        n2 = methodWriter.visitFrameStart(this.owner.bytecodeOffset, n3, n7);
        n5 = 0;
        while (n3-- > 0) {
            n5 += (n = nArray[n5]) == 0x400004 || n == 0x400003 ? 2 : 1;
            methodWriter.visitAbstractType(n2++, n);
        }
        n5 = 0;
        while (n7-- > 0) {
            n5 += (n = nArray2[n5]) == 0x400004 || n == 0x400003 ? 2 : 1;
            methodWriter.visitAbstractType(n2++, n);
        }
        methodWriter.visitFrameEnd();
    }

    static void putAbstractType(SymbolTable symbolTable, int n, ByteVector byteVector) {
        int n2 = (n & 0xFC000000) >> 26;
        if (n2 == 0) {
            int n3 = n & 0xFFFFF;
            switch (n & 0x3C00000) {
                case 0x400000: {
                    byteVector.putByte(n3);
                    break;
                }
                case 0x800000: {
                    byteVector.putByte(7).putShort(symbolTable.addConstantClass((String)symbolTable.getType((int)n3).value).index);
                    break;
                }
                case 0xC00000: {
                    byteVector.putByte(8).putShort((int)symbolTable.getType((int)n3).data);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            while (n2-- > 0) {
                stringBuilder.append('[');
            }
            if ((n & 0x3C00000) == 0x800000) {
                stringBuilder.append('L').append(symbolTable.getType((int)(n & 0xFFFFF)).value).append(';');
            } else {
                switch (n & 0xFFFFF) {
                    case 9: {
                        stringBuilder.append('Z');
                        break;
                    }
                    case 10: {
                        stringBuilder.append('B');
                        break;
                    }
                    case 11: {
                        stringBuilder.append('C');
                        break;
                    }
                    case 12: {
                        stringBuilder.append('S');
                        break;
                    }
                    case 1: {
                        stringBuilder.append('I');
                        break;
                    }
                    case 2: {
                        stringBuilder.append('F');
                        break;
                    }
                    case 4: {
                        stringBuilder.append('J');
                        break;
                    }
                    case 3: {
                        stringBuilder.append('D');
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            byteVector.putByte(7).putShort(symbolTable.addConstantClass((String)stringBuilder.toString()).index);
        }
    }
}

