/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.repackage.org.objectweb.asm.AnnotationVisitor;
import pro.gravit.repackage.org.objectweb.asm.Attribute;
import pro.gravit.repackage.org.objectweb.asm.ClassVisitor;
import pro.gravit.repackage.org.objectweb.asm.FieldVisitor;
import pro.gravit.repackage.org.objectweb.asm.MethodVisitor;
import pro.gravit.repackage.org.objectweb.asm.ModuleVisitor;
import pro.gravit.repackage.org.objectweb.asm.RecordComponentVisitor;
import pro.gravit.repackage.org.objectweb.asm.TypePath;
import pro.gravit.repackage.org.objectweb.asm.tree.AnnotationNode;
import pro.gravit.repackage.org.objectweb.asm.tree.FieldNode;
import pro.gravit.repackage.org.objectweb.asm.tree.InnerClassNode;
import pro.gravit.repackage.org.objectweb.asm.tree.MethodNode;
import pro.gravit.repackage.org.objectweb.asm.tree.ModuleNode;
import pro.gravit.repackage.org.objectweb.asm.tree.RecordComponentNode;
import pro.gravit.repackage.org.objectweb.asm.tree.TypeAnnotationNode;
import pro.gravit.repackage.org.objectweb.asm.tree.UnsupportedClassVersionException;
import pro.gravit.repackage.org.objectweb.asm.tree.Util;

public class ClassNode
extends ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List<String> interfaces = new ArrayList<String>();
    public String sourceFile;
    public String sourceDebug;
    public ModuleNode module;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public String nestHostClass;
    public List<String> nestMembers;
    public List<String> permittedSubclasses;
    public List<RecordComponentNode> recordComponents;
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();

    public ClassNode() {
        this(589824);
        if (this.getClass() != ClassNode.class) {
            throw new IllegalStateException();
        }
    }

    public ClassNode(int n) {
        super(n);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.version = n;
        this.access = n2;
        this.name = string;
        this.signature = string2;
        this.superName = string3;
        this.interfaces = Util.asArrayList(stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
        this.sourceFile = string;
        this.sourceDebug = string2;
    }

    @Override
    public ModuleVisitor visitModule(String string, int n, String string2) {
        this.module = new ModuleNode(string, n, string2);
        return this.module;
    }

    @Override
    public void visitNestHost(String string) {
        this.nestHostClass = string;
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.outerClass = string;
        this.outerMethod = string2;
        this.outerMethodDesc = string3;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            this.visibleAnnotations = Util.add(this.visibleAnnotations, annotationNode);
        } else {
            this.invisibleAnnotations = Util.add(this.invisibleAnnotations, annotationNode);
        }
        return annotationNode;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            this.visibleTypeAnnotations = Util.add(this.visibleTypeAnnotations, typeAnnotationNode);
        } else {
            this.invisibleTypeAnnotations = Util.add(this.invisibleTypeAnnotations, typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.attrs = Util.add(this.attrs, attribute);
    }

    @Override
    public void visitNestMember(String string) {
        this.nestMembers = Util.add(this.nestMembers, string);
    }

    @Override
    public void visitPermittedSubclass(String string) {
        this.permittedSubclasses = Util.add(this.permittedSubclasses, string);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        InnerClassNode innerClassNode = new InnerClassNode(string, string2, string3, n);
        this.innerClasses.add(innerClassNode);
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(String string, String string2, String string3) {
        RecordComponentNode recordComponentNode = new RecordComponentNode(string, string2, string3);
        this.recordComponents = Util.add(this.recordComponents, recordComponentNode);
        return recordComponentNode;
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldNode fieldNode = new FieldNode(n, string, string2, string3, object);
        this.fields.add(fieldNode);
        return fieldNode;
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodNode methodNode = new MethodNode(n, string, string2, string3, stringArray);
        this.methods.add(methodNode);
        return methodNode;
    }

    @Override
    public void visitEnd() {
    }

    public void check(int n) {
        int n2;
        if (n < 589824 && this.permittedSubclasses != null) {
            throw new UnsupportedClassVersionException();
        }
        if (n < 524288 && ((this.access & 0x10000) != 0 || this.recordComponents != null)) {
            throw new UnsupportedClassVersionException();
        }
        if (n < 458752 && (this.nestHostClass != null || this.nestMembers != null)) {
            throw new UnsupportedClassVersionException();
        }
        if (n < 393216 && this.module != null) {
            throw new UnsupportedClassVersionException();
        }
        if (n < 327680) {
            if (this.visibleTypeAnnotations != null && !this.visibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleTypeAnnotations != null && !this.invisibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
        }
        if (this.visibleAnnotations != null) {
            for (n2 = this.visibleAnnotations.size() - 1; n2 >= 0; --n2) {
                this.visibleAnnotations.get(n2).check(n);
            }
        }
        if (this.invisibleAnnotations != null) {
            for (n2 = this.invisibleAnnotations.size() - 1; n2 >= 0; --n2) {
                this.invisibleAnnotations.get(n2).check(n);
            }
        }
        if (this.visibleTypeAnnotations != null) {
            for (n2 = this.visibleTypeAnnotations.size() - 1; n2 >= 0; --n2) {
                this.visibleTypeAnnotations.get(n2).check(n);
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            for (n2 = this.invisibleTypeAnnotations.size() - 1; n2 >= 0; --n2) {
                this.invisibleTypeAnnotations.get(n2).check(n);
            }
        }
        if (this.recordComponents != null) {
            for (n2 = this.recordComponents.size() - 1; n2 >= 0; --n2) {
                this.recordComponents.get(n2).check(n);
            }
        }
        for (n2 = this.fields.size() - 1; n2 >= 0; --n2) {
            this.fields.get(n2).check(n);
        }
        for (n2 = this.methods.size() - 1; n2 >= 0; --n2) {
            this.methods.get(n2).check(n);
        }
    }

    public void accept(ClassVisitor classVisitor) {
        AnnotationNode annotationNode;
        int n;
        int n2;
        String[] stringArray = new String[this.interfaces.size()];
        this.interfaces.toArray(stringArray);
        classVisitor.visit(this.version, this.access, this.name, this.signature, this.superName, stringArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.module != null) {
            this.module.accept(classVisitor);
        }
        if (this.nestHostClass != null) {
            classVisitor.visitNestHost(this.nestHostClass);
        }
        if (this.outerClass != null) {
            classVisitor.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        if (this.visibleAnnotations != null) {
            n2 = this.visibleAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.visibleAnnotations.get(n);
                annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n2 = this.invisibleAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.invisibleAnnotations.get(n);
                annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n2 = this.visibleTypeAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.visibleTypeAnnotations.get(n);
                annotationNode.accept(classVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n2 = this.invisibleTypeAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.invisibleTypeAnnotations.get(n);
                annotationNode.accept(classVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, false));
            }
        }
        if (this.attrs != null) {
            n2 = this.attrs.size();
            for (n = 0; n < n2; ++n) {
                classVisitor.visitAttribute(this.attrs.get(n));
            }
        }
        if (this.nestMembers != null) {
            n2 = this.nestMembers.size();
            for (n = 0; n < n2; ++n) {
                classVisitor.visitNestMember(this.nestMembers.get(n));
            }
        }
        if (this.permittedSubclasses != null) {
            n2 = this.permittedSubclasses.size();
            for (n = 0; n < n2; ++n) {
                classVisitor.visitPermittedSubclass(this.permittedSubclasses.get(n));
            }
        }
        n2 = this.innerClasses.size();
        for (n = 0; n < n2; ++n) {
            this.innerClasses.get(n).accept(classVisitor);
        }
        if (this.recordComponents != null) {
            n2 = this.recordComponents.size();
            for (n = 0; n < n2; ++n) {
                this.recordComponents.get(n).accept(classVisitor);
            }
        }
        n2 = this.fields.size();
        for (n = 0; n < n2; ++n) {
            this.fields.get(n).accept(classVisitor);
        }
        n2 = this.methods.size();
        for (n = 0; n < n2; ++n) {
            this.methods.get(n).accept(classVisitor);
        }
        classVisitor.visitEnd();
    }
}

