/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm.tree;

import java.util.ListIterator;
import pro.gravit.repackage.org.objectweb.asm.MethodVisitor;
import pro.gravit.repackage.org.objectweb.asm.tree.AbstractInsnNode;
import pro.gravit.repackage.org.objectweb.asm.tree.InsnList$InsnListIterator;
import pro.gravit.repackage.org.objectweb.asm.tree.LabelNode;

public class InsnList
implements Iterable<AbstractInsnNode> {
    private int size;
    private AbstractInsnNode firstInsn;
    private AbstractInsnNode lastInsn;
    AbstractInsnNode[] cache;

    public int size() {
        return this.size;
    }

    public AbstractInsnNode getFirst() {
        return this.firstInsn;
    }

    public AbstractInsnNode getLast() {
        return this.lastInsn;
    }

    public AbstractInsnNode get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return this.cache[n];
    }

    public boolean contains(AbstractInsnNode abstractInsnNode) {
        AbstractInsnNode abstractInsnNode2 = this.firstInsn;
        while (abstractInsnNode2 != null && abstractInsnNode2 != abstractInsnNode) {
            abstractInsnNode2 = abstractInsnNode2.nextInsn;
        }
        return abstractInsnNode2 != null;
    }

    public int indexOf(AbstractInsnNode abstractInsnNode) {
        if (this.cache == null) {
            this.cache = this.toArray();
        }
        return abstractInsnNode.index;
    }

    public void accept(MethodVisitor methodVisitor) {
        AbstractInsnNode abstractInsnNode = this.firstInsn;
        while (abstractInsnNode != null) {
            abstractInsnNode.accept(methodVisitor);
            abstractInsnNode = abstractInsnNode.nextInsn;
        }
    }

    @Override
    public ListIterator<AbstractInsnNode> iterator() {
        return this.iterator(0);
    }

    public ListIterator<AbstractInsnNode> iterator(int n) {
        return new InsnList$InsnListIterator(this, n);
    }

    public AbstractInsnNode[] toArray() {
        int n = 0;
        AbstractInsnNode abstractInsnNode = this.firstInsn;
        AbstractInsnNode[] abstractInsnNodeArray = new AbstractInsnNode[this.size];
        while (abstractInsnNode != null) {
            abstractInsnNodeArray[n] = abstractInsnNode;
            abstractInsnNode.index = n++;
            abstractInsnNode = abstractInsnNode.nextInsn;
        }
        return abstractInsnNodeArray;
    }

    public void set(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        AbstractInsnNode abstractInsnNode3;
        AbstractInsnNode abstractInsnNode4;
        abstractInsnNode2.nextInsn = abstractInsnNode4 = abstractInsnNode.nextInsn;
        if (abstractInsnNode4 != null) {
            abstractInsnNode4.previousInsn = abstractInsnNode2;
        } else {
            this.lastInsn = abstractInsnNode2;
        }
        abstractInsnNode2.previousInsn = abstractInsnNode3 = abstractInsnNode.previousInsn;
        if (abstractInsnNode3 != null) {
            abstractInsnNode3.nextInsn = abstractInsnNode2;
        } else {
            this.firstInsn = abstractInsnNode2;
        }
        if (this.cache != null) {
            int n = abstractInsnNode.index;
            this.cache[n] = abstractInsnNode2;
            abstractInsnNode2.index = n;
        } else {
            abstractInsnNode2.index = 0;
        }
        abstractInsnNode.index = -1;
        abstractInsnNode.previousInsn = null;
        abstractInsnNode.nextInsn = null;
    }

    public void add(AbstractInsnNode abstractInsnNode) {
        ++this.size;
        if (this.lastInsn == null) {
            this.firstInsn = abstractInsnNode;
            this.lastInsn = abstractInsnNode;
        } else {
            this.lastInsn.nextInsn = abstractInsnNode;
            abstractInsnNode.previousInsn = this.lastInsn;
        }
        this.lastInsn = abstractInsnNode;
        this.cache = null;
        abstractInsnNode.index = 0;
    }

    public void add(InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.lastInsn == null) {
            this.firstInsn = insnList.firstInsn;
            this.lastInsn = insnList.lastInsn;
        } else {
            AbstractInsnNode abstractInsnNode;
            this.lastInsn.nextInsn = abstractInsnNode = insnList.firstInsn;
            abstractInsnNode.previousInsn = this.lastInsn;
            this.lastInsn = insnList.lastInsn;
        }
        this.cache = null;
        insnList.removeAll(false);
    }

    public void insert(AbstractInsnNode abstractInsnNode) {
        ++this.size;
        if (this.firstInsn == null) {
            this.firstInsn = abstractInsnNode;
            this.lastInsn = abstractInsnNode;
        } else {
            this.firstInsn.previousInsn = abstractInsnNode;
            abstractInsnNode.nextInsn = this.firstInsn;
        }
        this.firstInsn = abstractInsnNode;
        this.cache = null;
        abstractInsnNode.index = 0;
    }

    public void insert(InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        if (this.firstInsn == null) {
            this.firstInsn = insnList.firstInsn;
            this.lastInsn = insnList.lastInsn;
        } else {
            AbstractInsnNode abstractInsnNode;
            this.firstInsn.previousInsn = abstractInsnNode = insnList.lastInsn;
            abstractInsnNode.nextInsn = this.firstInsn;
            this.firstInsn = insnList.firstInsn;
        }
        this.cache = null;
        insnList.removeAll(false);
    }

    public void insert(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        ++this.size;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.nextInsn;
        if (abstractInsnNode3 == null) {
            this.lastInsn = abstractInsnNode2;
        } else {
            abstractInsnNode3.previousInsn = abstractInsnNode2;
        }
        abstractInsnNode.nextInsn = abstractInsnNode2;
        abstractInsnNode2.nextInsn = abstractInsnNode3;
        abstractInsnNode2.previousInsn = abstractInsnNode;
        this.cache = null;
        abstractInsnNode2.index = 0;
    }

    public void insert(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode abstractInsnNode2 = insnList.firstInsn;
        AbstractInsnNode abstractInsnNode3 = insnList.lastInsn;
        AbstractInsnNode abstractInsnNode4 = abstractInsnNode.nextInsn;
        if (abstractInsnNode4 == null) {
            this.lastInsn = abstractInsnNode3;
        } else {
            abstractInsnNode4.previousInsn = abstractInsnNode3;
        }
        abstractInsnNode.nextInsn = abstractInsnNode2;
        abstractInsnNode3.nextInsn = abstractInsnNode4;
        abstractInsnNode2.previousInsn = abstractInsnNode;
        this.cache = null;
        insnList.removeAll(false);
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        ++this.size;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.previousInsn;
        if (abstractInsnNode3 == null) {
            this.firstInsn = abstractInsnNode2;
        } else {
            abstractInsnNode3.nextInsn = abstractInsnNode2;
        }
        abstractInsnNode.previousInsn = abstractInsnNode2;
        abstractInsnNode2.nextInsn = abstractInsnNode;
        abstractInsnNode2.previousInsn = abstractInsnNode3;
        this.cache = null;
        abstractInsnNode2.index = 0;
    }

    public void insertBefore(AbstractInsnNode abstractInsnNode, InsnList insnList) {
        if (insnList.size == 0) {
            return;
        }
        this.size += insnList.size;
        AbstractInsnNode abstractInsnNode2 = insnList.firstInsn;
        AbstractInsnNode abstractInsnNode3 = insnList.lastInsn;
        AbstractInsnNode abstractInsnNode4 = abstractInsnNode.previousInsn;
        if (abstractInsnNode4 == null) {
            this.firstInsn = abstractInsnNode2;
        } else {
            abstractInsnNode4.nextInsn = abstractInsnNode2;
        }
        abstractInsnNode.previousInsn = abstractInsnNode3;
        abstractInsnNode3.nextInsn = abstractInsnNode;
        abstractInsnNode2.previousInsn = abstractInsnNode4;
        this.cache = null;
        insnList.removeAll(false);
    }

    public void remove(AbstractInsnNode abstractInsnNode) {
        --this.size;
        AbstractInsnNode abstractInsnNode2 = abstractInsnNode.nextInsn;
        AbstractInsnNode abstractInsnNode3 = abstractInsnNode.previousInsn;
        if (abstractInsnNode2 == null) {
            if (abstractInsnNode3 == null) {
                this.firstInsn = null;
                this.lastInsn = null;
            } else {
                abstractInsnNode3.nextInsn = null;
                this.lastInsn = abstractInsnNode3;
            }
        } else if (abstractInsnNode3 == null) {
            this.firstInsn = abstractInsnNode2;
            abstractInsnNode2.previousInsn = null;
        } else {
            abstractInsnNode3.nextInsn = abstractInsnNode2;
            abstractInsnNode2.previousInsn = abstractInsnNode3;
        }
        this.cache = null;
        abstractInsnNode.index = -1;
        abstractInsnNode.previousInsn = null;
        abstractInsnNode.nextInsn = null;
    }

    void removeAll(boolean bl) {
        if (bl) {
            AbstractInsnNode abstractInsnNode = this.firstInsn;
            while (abstractInsnNode != null) {
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode.nextInsn;
                abstractInsnNode.index = -1;
                abstractInsnNode.previousInsn = null;
                abstractInsnNode.nextInsn = null;
                abstractInsnNode = abstractInsnNode2;
            }
        }
        this.size = 0;
        this.firstInsn = null;
        this.lastInsn = null;
        this.cache = null;
    }

    public void clear() {
        this.removeAll(false);
    }

    public void resetLabels() {
        AbstractInsnNode abstractInsnNode = this.firstInsn;
        while (abstractInsnNode != null) {
            if (abstractInsnNode instanceof LabelNode) {
                ((LabelNode)abstractInsnNode).resetLabel();
            }
            abstractInsnNode = abstractInsnNode.nextInsn;
        }
    }
}

