/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.repackage.org.objectweb.asm.ClassVisitor;
import pro.gravit.repackage.org.objectweb.asm.ModuleVisitor;
import pro.gravit.repackage.org.objectweb.asm.tree.ModuleExportNode;
import pro.gravit.repackage.org.objectweb.asm.tree.ModuleOpenNode;
import pro.gravit.repackage.org.objectweb.asm.tree.ModuleProvideNode;
import pro.gravit.repackage.org.objectweb.asm.tree.ModuleRequireNode;
import pro.gravit.repackage.org.objectweb.asm.tree.Util;

public class ModuleNode
extends ModuleVisitor {
    public String name;
    public int access;
    public String version;
    public String mainClass;
    public List<String> packages;
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<ModuleOpenNode> opens;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode(String string, int n, String string2) {
        super(589824);
        if (this.getClass() != ModuleNode.class) {
            throw new IllegalStateException();
        }
        this.name = string;
        this.access = n;
        this.version = string2;
    }

    public ModuleNode(int n, String string, int n2, String string2, List<ModuleRequireNode> list, List<ModuleExportNode> list2, List<ModuleOpenNode> list3, List<String> list4, List<ModuleProvideNode> list5) {
        super(n);
        this.name = string;
        this.access = n2;
        this.version = string2;
        this.requires = list;
        this.exports = list2;
        this.opens = list3;
        this.uses = list4;
        this.provides = list5;
    }

    @Override
    public void visitMainClass(String string) {
        this.mainClass = string;
    }

    @Override
    public void visitPackage(String string) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>(5);
        }
        this.packages.add(string);
    }

    @Override
    public void visitRequire(String string, int n, String string2) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(string, n, string2));
    }

    @Override
    public void visitExport(String string, int n, String ... stringArray) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        this.exports.add(new ModuleExportNode(string, n, Util.asArrayList(stringArray)));
    }

    @Override
    public void visitOpen(String string, int n, String ... stringArray) {
        if (this.opens == null) {
            this.opens = new ArrayList<ModuleOpenNode>(5);
        }
        this.opens.add(new ModuleOpenNode(string, n, Util.asArrayList(stringArray)));
    }

    @Override
    public void visitUse(String string) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(string);
    }

    @Override
    public void visitProvide(String string, String ... stringArray) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        this.provides.add(new ModuleProvideNode(string, Util.asArrayList(stringArray)));
    }

    @Override
    public void visitEnd() {
    }

    public void accept(ClassVisitor classVisitor) {
        int n;
        int n2;
        ModuleVisitor moduleVisitor = classVisitor.visitModule(this.name, this.access, this.version);
        if (moduleVisitor == null) {
            return;
        }
        if (this.mainClass != null) {
            moduleVisitor.visitMainClass(this.mainClass);
        }
        if (this.packages != null) {
            n2 = this.packages.size();
            for (n = 0; n < n2; ++n) {
                moduleVisitor.visitPackage(this.packages.get(n));
            }
        }
        if (this.requires != null) {
            n2 = this.requires.size();
            for (n = 0; n < n2; ++n) {
                this.requires.get(n).accept(moduleVisitor);
            }
        }
        if (this.exports != null) {
            n2 = this.exports.size();
            for (n = 0; n < n2; ++n) {
                this.exports.get(n).accept(moduleVisitor);
            }
        }
        if (this.opens != null) {
            n2 = this.opens.size();
            for (n = 0; n < n2; ++n) {
                this.opens.get(n).accept(moduleVisitor);
            }
        }
        if (this.uses != null) {
            n2 = this.uses.size();
            for (n = 0; n < n2; ++n) {
                moduleVisitor.visitUse(this.uses.get(n));
            }
        }
        if (this.provides != null) {
            n2 = this.provides.size();
            for (n = 0; n < n2; ++n) {
                this.provides.get(n).accept(moduleVisitor);
            }
        }
    }
}

