/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm.tree;

import java.util.List;
import pro.gravit.repackage.org.objectweb.asm.AnnotationVisitor;
import pro.gravit.repackage.org.objectweb.asm.Attribute;
import pro.gravit.repackage.org.objectweb.asm.ClassVisitor;
import pro.gravit.repackage.org.objectweb.asm.RecordComponentVisitor;
import pro.gravit.repackage.org.objectweb.asm.TypePath;
import pro.gravit.repackage.org.objectweb.asm.tree.AnnotationNode;
import pro.gravit.repackage.org.objectweb.asm.tree.TypeAnnotationNode;
import pro.gravit.repackage.org.objectweb.asm.tree.UnsupportedClassVersionException;
import pro.gravit.repackage.org.objectweb.asm.tree.Util;

public class RecordComponentNode
extends RecordComponentVisitor {
    public String name;
    public String descriptor;
    public String signature;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;

    public RecordComponentNode(String string, String string2, String string3) {
        this(589824, string, string2, string3);
        if (this.getClass() != RecordComponentNode.class) {
            throw new IllegalStateException();
        }
    }

    public RecordComponentNode(int n, String string, String string2, String string3) {
        super(n);
        this.name = string;
        this.descriptor = string2;
        this.signature = string3;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            this.visibleAnnotations = Util.add(this.visibleAnnotations, annotationNode);
        } else {
            this.invisibleAnnotations = Util.add(this.invisibleAnnotations, annotationNode);
        }
        return annotationNode;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        TypeAnnotationNode typeAnnotationNode = new TypeAnnotationNode(n, typePath, string);
        if (bl) {
            this.visibleTypeAnnotations = Util.add(this.visibleTypeAnnotations, typeAnnotationNode);
        } else {
            this.invisibleTypeAnnotations = Util.add(this.invisibleTypeAnnotations, typeAnnotationNode);
        }
        return typeAnnotationNode;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.attrs = Util.add(this.attrs, attribute);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int n) {
        if (n < 524288) {
            throw new UnsupportedClassVersionException();
        }
    }

    public void accept(ClassVisitor classVisitor) {
        AnnotationNode annotationNode;
        int n;
        int n2;
        RecordComponentVisitor recordComponentVisitor = classVisitor.visitRecordComponent(this.name, this.descriptor, this.signature);
        if (recordComponentVisitor == null) {
            return;
        }
        if (this.visibleAnnotations != null) {
            n2 = this.visibleAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.visibleAnnotations.get(n);
                annotationNode.accept(recordComponentVisitor.visitAnnotation(annotationNode.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n2 = this.invisibleAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.invisibleAnnotations.get(n);
                annotationNode.accept(recordComponentVisitor.visitAnnotation(annotationNode.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n2 = this.visibleTypeAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.visibleTypeAnnotations.get(n);
                annotationNode.accept(recordComponentVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n2 = this.invisibleTypeAnnotations.size();
            for (n = 0; n < n2; ++n) {
                annotationNode = this.invisibleTypeAnnotations.get(n);
                annotationNode.accept(recordComponentVisitor.visitTypeAnnotation(((TypeAnnotationNode)annotationNode).typeRef, ((TypeAnnotationNode)annotationNode).typePath, ((TypeAnnotationNode)annotationNode).desc, false));
            }
        }
        if (this.attrs != null) {
            n2 = this.attrs.size();
            for (n = 0; n < n2; ++n) {
                recordComponentVisitor.visitAttribute(this.attrs.get(n));
            }
        }
        recordComponentVisitor.visitEnd();
    }
}

