/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.org.objectweb.asm.tree;

import java.util.List;
import java.util.Map;
import pro.gravit.repackage.org.objectweb.asm.Label;
import pro.gravit.repackage.org.objectweb.asm.MethodVisitor;
import pro.gravit.repackage.org.objectweb.asm.tree.AbstractInsnNode;
import pro.gravit.repackage.org.objectweb.asm.tree.LabelNode;
import pro.gravit.repackage.org.objectweb.asm.tree.Util;

public class TableSwitchInsnNode
extends AbstractInsnNode {
    public int min;
    public int max;
    public LabelNode dflt;
    public List<LabelNode> labels;

    public TableSwitchInsnNode(int n, int n2, LabelNode labelNode, LabelNode ... labelNodeArray) {
        super(170);
        this.min = n;
        this.max = n2;
        this.dflt = labelNode;
        this.labels = Util.asArrayList(labelNodeArray);
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        Label[] labelArray = new Label[this.labels.size()];
        int n = labelArray.length;
        for (int i = 0; i < n; ++i) {
            labelArray[i] = this.labels.get(i).getLabel();
        }
        methodVisitor.visitTableSwitchInsn(this.min, this.max, this.dflt.getLabel(), labelArray);
        this.acceptAnnotations(methodVisitor);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        return new TableSwitchInsnNode(this.min, this.max, TableSwitchInsnNode.clone(this.dflt, map), TableSwitchInsnNode.clone(this.labels, map)).cloneAnnotations(this);
    }
}

