/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.enfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.enfs.dir.Directory;
import pro.gravit.utils.enfs.dir.FileEntry;
import pro.gravit.utils.enfs.dir.MemoryFile;
import pro.gravit.utils.enfs.dir.URLFile;
import pro.gravit.utils.enfs.protocol.enfs.Handler;

public final class EnFS {
    public static final EnFS main = new EnFS("");
    private static final Map<String, EnFS> map = new ConcurrentHashMap<String, EnFS>();
    private final Directory root = new Directory();
    private final String name;

    private EnFS(String string) {
        this.name = string;
    }

    public static EnFS getByName(String string) {
        if (string == null || string.isEmpty()) {
            return main;
        }
        return map.get(string);
    }

    public static EnFS newInstance(String string) {
        if (map.containsKey(string)) {
            return map.get(string);
        }
        return map.put(string, new EnFS(string));
    }

    public final void newDirectory(Path path) throws IOException {
        this.addFile(path, new Directory());
    }

    public final void newDirectories(Path path) {
        if (path == null) {
            return;
        }
        Directory directory = this.root;
        for (Path path2 : path) {
            Directory directory2 = (Directory)directory.get(path2.toString());
            if (directory2 == null) {
                directory2 = new Directory();
                directory.add(path2.toString(), directory2);
            }
            directory = directory2;
        }
    }

    public final void delete(Path path) throws IOException {
        FileEntry fileEntry = this.root.find(path.getParent());
        if (fileEntry == null) {
            throw new FileNotFoundException(String.format("File %s not found", path));
        }
        if (fileEntry == this.root) {
            throw new SecurityException("Root / can't delete");
        }
        if (((Directory)fileEntry).delete(path.getFileName().toString()) == null) {
            throw new FileNotFoundException(String.format("File %s not found", path));
        }
    }

    public final InputStream getInputStream(Path path) throws IOException {
        FileEntry fileEntry = this.root.find(path);
        if (fileEntry == null) {
            throw new FileNotFoundException(String.format("File %s not found", path));
        }
        return fileEntry.getInputStream();
    }

    public final void addFile(Path path, FileEntry fileEntry) throws IOException {
        FileEntry fileEntry2 = this.root.find(path.getParent());
        if (fileEntry2 == null) {
            throw new FileNotFoundException(String.format("Directory %s not found", path.getParent()));
        }
        if (!(fileEntry2 instanceof Directory)) {
            throw new IOException(String.format("%s is not directory", path.getParent()));
        }
        ((Directory)fileEntry2).add(path.getFileName().toString(), fileEntry);
    }

    public final void addFile(Path path, byte[] byArray) throws IOException {
        this.addFile(path, new MemoryFile(byArray));
    }

    public final void addFile(Path path, URL uRL) throws IOException {
        this.addFile(path, new URLFile(uRL));
    }

    public final URL getURL(Path path) throws MalformedURLException {
        return new URL("enfs", this.name, 0, URLEncoder.encode(path.toString()).replaceAll("%2F", "/"), new Handler());
    }

    public final void clear() {
        this.root.clear();
    }
}

