/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.util.Objects;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class CryptoHelper {
    private CryptoHelper() {
    }

    public static byte[] encode(byte[] byArray, String string) {
        Objects.requireNonNull(byArray);
        Objects.requireNonNull(string);
        byte[] byArray2 = SecurityHelper.fromHex(string);
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i % byArray2.length]);
        }
        return byArray3;
    }

    public static byte[] decode(byte[] byArray, String string) {
        Objects.requireNonNull(byArray);
        Objects.requireNonNull(string);
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = SecurityHelper.fromHex(string);
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(byArray[i] ^ byArray3[i % byArray3.length]);
        }
        return byArray2;
    }

    public static void encodeOrig(byte[] byArray, String string) {
        Objects.requireNonNull(byArray);
        Objects.requireNonNull(string);
        byte[] byArray2 = SecurityHelper.fromHex(string);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] ^ byArray2[i % byArray2.length]);
        }
    }

    public static void decodeOrig(byte[] byArray, String string) {
        Objects.requireNonNull(byArray);
        Objects.requireNonNull(string);
        byte[] byArray2 = SecurityHelper.fromHex(string);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] ^ byArray2[i % byArray2.length]);
        }
    }

    public static String randomToken(int n) {
        VerifyHelper.verifyInt(n, VerifyHelper.POSITIVE, "Depth must be positive");
        return SecurityHelper.toHex(SecurityHelper.randomBytes(16 * n));
    }
}

