/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import pro.gravit.utils.helper.JVMHelper$OS;
import pro.gravit.utils.helper.LogHelper;

public final class JVMHelper {
    public static final RuntimeMXBean RUNTIME_MXBEAN = ManagementFactory.getRuntimeMXBean();
    public static final OperatingSystemMXBean OPERATING_SYSTEM_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    public static final JVMHelper$OS OS_TYPE = JVMHelper$OS.byName(OPERATING_SYSTEM_MXBEAN.getName());
    public static final String OS_VERSION = OPERATING_SYSTEM_MXBEAN.getVersion();
    public static final int OS_BITS = JVMHelper.getCorrectOSArch();
    public static final int JVM_BITS = Integer.parseInt(System.getProperty("sun.arch.data.model"));
    public static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    public static final Runtime RUNTIME = Runtime.getRuntime();
    public static final ClassLoader LOADER = ClassLoader.getSystemClassLoader();
    public static final int JVM_VERSION = JVMHelper.getVersion();
    public static final int JVM_BUILD = JVMHelper.getBuild();

    private JVMHelper() {
    }

    public static int getVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            string = string.substring(2, 3);
        } else {
            int n = string.indexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return Integer.parseInt(string);
    }

    public static int getBuild() {
        String string = System.getProperty("java.version");
        int n = string.startsWith("1.") ? string.indexOf("_") : string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static void appendVars(ProcessBuilder processBuilder, Map<String, String> map) {
        processBuilder.environment().putAll(map);
    }

    public static Class<?> firstClass(String ... stringArray) {
        for (String string : stringArray) {
            try {
                return Class.forName(string, false, LOADER);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(Arrays.toString(stringArray));
    }

    public static void fullGC() {
        RUNTIME.gc();
        RUNTIME.runFinalization();
        LogHelper.debug("Used heap: %d MiB", RUNTIME.totalMemory() - RUNTIME.freeMemory() >> 20);
    }

    public static String[] getClassPath() {
        return System.getProperty("java.class.path").split(File.pathSeparator);
    }

    public static URL[] getClassPathURL() {
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL = null;
            try {
                uRL = new URL(stringArray[i]);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            uRLArray[i] = uRL;
        }
        return uRLArray;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(objectArray).filter(object -> object instanceof X509Certificate).map(object -> (X509Certificate)object).toArray(X509Certificate[]::new);
    }

    public static void checkStackTrace(Class<?> clazz) {
        LogHelper.debug("Testing stacktrace");
        Exception exception = new Exception("Testing stacktrace");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (!stackTraceElementArray[stackTraceElementArray.length - 1].getClassName().equals(clazz.getName())) {
            throw new SecurityException(String.format("Invalid StackTraceElement: %s", stackTraceElementArray[stackTraceElementArray.length - 1].getClassName()));
        }
    }

    private static int getCorrectOSArch() {
        if (OS_TYPE == JVMHelper$OS.MUSTDIE) {
            return System.getenv("ProgramFiles(x86)") == null ? 32 : 64;
        }
        return System.getProperty("os.arch").contains("64") ? 64 : 32;
    }

    public static String getEnvPropertyCaseSensitive(String string) {
        return System.getenv().get(string);
    }

    public static boolean isJVMMatchesSystemArch() {
        return JVM_BITS == OS_BITS;
    }

    public static String jvmProperty(String string, String string2) {
        return String.format("-D%s=%s", string, string2);
    }

    public static String systemToJvmProperty(String string) {
        return String.format("-D%s=%s", string, System.getProperties().getProperty(string));
    }

    public static void addSystemPropertyToArgs(Collection<String> collection, String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            collection.add(String.format("-D%s=%s", string, string2));
        }
    }

    public static void verifySystemProperties(Class<?> clazz, boolean bl) {
        Locale.setDefault(Locale.US);
        LogHelper.debug("Verifying class loader");
        if (bl && !clazz.getClassLoader().equals(LOADER)) {
            throw new SecurityException("ClassLoader should be system");
        }
        LogHelper.debug("Verifying JVM architecture");
        if (!JVMHelper.isJVMMatchesSystemArch()) {
            LogHelper.warning("Java and OS architecture mismatch");
            LogHelper.warning("It's recommended to download %d-bit JRE", OS_BITS);
        }
    }

    static {
        try {
            MethodHandles.publicLookup();
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }
}

