/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.JavaHelper$JavaVersionAndBuild;

public class JavaHelper$JavaVersion {
    public final Path jvmDir;
    public final int version;
    public final int build;
    public final int bitness;
    public boolean enabledJavaFX;

    public JavaHelper$JavaVersion(Path path, int n) {
        this.jvmDir = path;
        this.version = n;
        this.build = 0;
        this.bitness = JVMHelper.OS_BITS;
        this.enabledJavaFX = true;
    }

    public JavaHelper$JavaVersion(Path path, int n, int n2, boolean bl) {
        this.jvmDir = path;
        this.version = n;
        this.build = n2;
        this.bitness = JVMHelper.OS_BITS;
        this.enabledJavaFX = bl;
    }

    public JavaHelper$JavaVersion(Path path, int n, int n2, int n3, boolean bl) {
        this.jvmDir = path;
        this.version = n;
        this.build = n2;
        this.bitness = n3;
        this.enabledJavaFX = bl;
    }

    public static JavaHelper$JavaVersion getCurrentJavaVersion() {
        return new JavaHelper$JavaVersion(Paths.get(System.getProperty("java.home"), new String[0]), JVMHelper.getVersion(), JVMHelper.JVM_BUILD, JVMHelper.JVM_BITS, JavaHelper$JavaVersion.isCurrentJavaSupportJavaFX());
    }

    private static boolean isCurrentJavaSupportJavaFX() {
        try {
            Class.forName("javafx.application.Application");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (JVMHelper.getVersion() > 8) {
                Path path = Paths.get(System.getProperty("java.home"), new String[0]);
                return JavaHelper.tryFindModule(path, "javafx.base") != null;
            }
            return false;
        }
    }

    public static JavaHelper$JavaVersion getByPath(Path path) {
        JavaHelper$JavaVersionAndBuild javaHelper$JavaVersionAndBuild;
        Object object;
        Object object2 = JavaHelper.access$000(path);
        if (object2 != null) {
            return object2;
        }
        object2 = path.resolve("release");
        int n = JVMHelper.OS_BITS;
        if (IOHelper.isFile((Path)object2)) {
            object = new Properties();
            ((Properties)object).load(IOHelper.newReader((Path)object2));
            javaHelper$JavaVersionAndBuild = JavaHelper.getJavaVersion(((Properties)object).getProperty("JAVA_VERSION").replaceAll("\"", ""));
            String string = ((Properties)object).getProperty("JAVA_VERSION").replaceAll("\"", "");
            if (string.contains("x86_64")) {
                n = 64;
            } else if (string.contains("x86") || string.contains("x32")) {
                n = 32;
            }
        } else {
            javaHelper$JavaVersionAndBuild = new JavaHelper$JavaVersionAndBuild(JavaHelper$JavaVersion.isExistExtJavaLibrary(path, "jfxrt") ? 8 : 9, 0);
        }
        object = new JavaHelper$JavaVersion(path, javaHelper$JavaVersionAndBuild.version, javaHelper$JavaVersionAndBuild.build, n, false);
        if (javaHelper$JavaVersionAndBuild.version <= 8) {
            ((JavaHelper$JavaVersion)object).enabledJavaFX = JavaHelper$JavaVersion.isExistExtJavaLibrary(path, "jfxrt");
        } else {
            boolean bl = ((JavaHelper$JavaVersion)object).enabledJavaFX = JavaHelper.tryFindModule(path, "javafx.base") != null;
            if (!((JavaHelper$JavaVersion)object).enabledJavaFX) {
                ((JavaHelper$JavaVersion)object).enabledJavaFX = JavaHelper.tryFindModule(path.resolve("jre"), "javafx.base") != null;
            }
        }
        return object;
    }

    public static boolean isExistExtJavaLibrary(Path path, String string) {
        Path path2 = path.resolve("lib").resolve("ext").resolve(string.concat(".jar"));
        Path path3 = path.resolve("jre").resolve("lib").resolve("ext").resolve(string.concat(".jar"));
        return IOHelper.isFile(path2) || IOHelper.isFile(path3);
    }
}

