/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.util.Map;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class VerifyHelper {
    public static final IntPredicate POSITIVE = n -> n > 0;
    public static final IntPredicate NOT_NEGATIVE = n -> n >= 0;
    public static final LongPredicate L_POSITIVE = l -> l > 0L;
    public static final LongPredicate L_NOT_NEGATIVE = l -> l >= 0L;
    public static final Predicate<String> NOT_EMPTY = string -> !string.isEmpty();
    public static final Pattern USERNAME_PATTERN = Pattern.compile(Boolean.parseBoolean(System.getProperty("username.russian", "true")) ? "[a-zA-Z\u0430-\u044f\u0410-\u042f0-9_.\\-]{1,16}" : "[a-zA-Z0-9-_\\\\.]{1,16}");
    private static final Pattern SERVERID_PATTERN = Pattern.compile("-?[0-9a-f]{1,40}");

    private VerifyHelper() {
    }

    public static <K, V> V getMapValue(Map<K, V> map, K k, String string) {
        return (V)VerifyHelper.verify(map.get(k), Objects::nonNull, string);
    }

    public static boolean isValidIDName(String string) {
        return !string.isEmpty() && string.length() <= 255 && string.chars().allMatch(VerifyHelper::isValidIDNameChar);
    }

    public static boolean isValidIDNameChar(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 45 || n == 95;
    }

    public static boolean isValidServerID(CharSequence charSequence) {
        return SERVERID_PATTERN.matcher(charSequence).matches();
    }

    public static boolean isValidUsername(CharSequence charSequence) {
        return USERNAME_PATTERN.matcher(charSequence).matches();
    }

    public static <K, V> void putIfAbsent(Map<K, V> map, K k, V v, String string) {
        VerifyHelper.verify(map.putIfAbsent(k, v), Objects::isNull, string);
    }

    public static IntPredicate range(int n, int n2) {
        return n3 -> n3 >= n && n3 <= n2;
    }

    public static <T> T verify(T t, Predicate<T> predicate, String string) {
        if (predicate.test(t)) {
            return t;
        }
        throw new IllegalArgumentException(string);
    }

    public static double verifyDouble(double d, DoublePredicate doublePredicate, String string) {
        if (doublePredicate.test(d)) {
            return d;
        }
        throw new IllegalArgumentException(string);
    }

    public static String verifyIDName(String string) {
        return VerifyHelper.verify(string, VerifyHelper::isValidIDName, String.format("Invalid name: '%s'", string));
    }

    public static int verifyInt(int n, IntPredicate intPredicate, String string) {
        if (intPredicate.test(n)) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    public static long verifyLong(long l, LongPredicate longPredicate, String string) {
        if (longPredicate.test(l)) {
            return l;
        }
        throw new IllegalArgumentException(string);
    }

    public static String verifyServerID(String string) {
        return VerifyHelper.verify(string, VerifyHelper::isValidServerID, String.format("Invalid server ID: '%s'", string));
    }

    public static String verifyUsername(String string) {
        return VerifyHelper.verify(string, VerifyHelper::isValidUsername, String.format("Invalid username: '%s'", string));
    }
}

